DROP TABLE CIS.CK_LOG CASCADE CONSTRAINTS;

CREATE TABLE CIS.CK_LOG
(
  LINENUM  NUMBER,
  LINEMSG  VARCHAR2(2000 BYTE)
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE OR REPLACE PUBLIC SYNONYM CK_LOG FOR CIS.CK_LOG;


GRANT SELECT ON CIS.CK_LOG TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CK_LOG TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_STATUS_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_STATUS_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_STATUS_TYPE_H
(
  CIS_VLDTN_STATUS_TYPE_H_ID  NUMBER(20)        NOT NULL,
  CIS_VLDTN_STATUS_TYPE_ID    NUMBER(20)        NOT NULL,
  VLDTN_STATUS_TYPE_CD        VARCHAR2(5 BYTE)  NOT NULL,
  VLDTN_STATUS_TYPE_NM        VARCHAR2(30 BYTE) NOT NULL,
  VLDTN_STATUS_TYPE_DESC_TX   VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  REC_CRTR_PARTY_ID           NUMBER(20)        NOT NULL,
  SRC_APLCTN_PARTY_ID         NUMBER(20)        NOT NULL,
  REC_MDFD_TYPE_CD            VARCHAR2(1 BYTE)  NOT NULL,
  REC_CRTD_DT                 DATE              DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_STATUS_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_VLDTN_STATUS_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_STATUS_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_STATUS_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_VLDTN_STATUS_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_STATUS_TYPE_H_PK ON CIS.CIS_VLDTN_STATUS_TYPE_H
(CIS_VLDTN_STATUS_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_STATUS_TYPE_H FOR CIS.CIS_VLDTN_STATUS_TYPE_H;


ALTER TABLE CIS.CIS_VLDTN_STATUS_TYPE_H ADD (
  CONSTRAINT CIS_VLDTN_STATUS_TYPE_H_PK
  PRIMARY KEY
  (CIS_VLDTN_STATUS_TYPE_H_ID)
  USING INDEX CIS.CIS_VLDTN_STATUS_TYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_STATUS_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_STATUS_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_STATUS_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_STATUS_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_STATUS_TYPE
(
  CIS_VLDTN_STATUS_TYPE_ID   NUMBER(20)         NOT NULL,
  VLDTN_STATUS_TYPE_CD       VARCHAR2(5 BYTE)   NOT NULL,
  VLDTN_STATUS_TYPE_NM       VARCHAR2(30 BYTE)  NOT NULL,
  VLDTN_STATUS_TYPE_DESC_TX  VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT               NUMBER(18)         NOT NULL,
  CIS_PROVENANCE_ID          NUMBER(20)         NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_STATUS_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_STATUS_TYPE_PK ON CIS.CIS_VLDTN_STATUS_TYPE
(CIS_VLDTN_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_STATUS_TYPE_UK_I ON CIS.CIS_VLDTN_STATUS_TYPE
(VLDTN_STATUS_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_STATUS_TY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_STATUS_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_STATUS_TYPE_H( CIS_VLDTN_STATUS_TYPE_H_ID,

CIS_VLDTN_STATUS_TYPE_ID,

VLDTN_STATUS_TYPE_CD,


VLDTN_STATUS_TYPE_NM,

VLDTN_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_STATUS_TYPE_H_S.nextval
,

:old.CIS_VLDTN_STATUS_TYPE_ID,

:old.VLDTN_STATUS_TYPE_CD,

:old.VLDTN_STATUS_TYPE_NM,

:old.VLDTN_STATUS_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_STATUS_TYPE_H( CIS_VLDTN_STATUS_TYPE_H_ID,

CIS_VLDTN_STATUS_TYPE_ID,

VLDTN_STATUS_TYPE_CD,


VLDTN_STATUS_TYPE_NM,

VLDTN_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_STATUS_TYPE_H_S.nextval
,

:new.CIS_VLDTN_STATUS_TYPE_ID,

:new.VLDTN_STATUS_TYPE_CD,

:new.VLDTN_STATUS_TYPE_NM,

:new.VLDTN_STATUS_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_VLDTN_STATUS_TY_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_STATUS_TYPE FOR CIS.CIS_VLDTN_STATUS_TYPE;


ALTER TABLE CIS.CIS_VLDTN_STATUS_TYPE ADD (
  CONSTRAINT CIS_VLDTN_STATUS_TYPE_PK
  PRIMARY KEY
  (CIS_VLDTN_STATUS_TYPE_ID)
  USING INDEX CIS.CIS_VLDTN_STATUS_TYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTN_STATUS_TYPE_UK
  UNIQUE (VLDTN_STATUS_TYPE_CD)
  USING INDEX CIS.CIS_VLDTN_STATUS_TYPE_UK_I
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_VLDTN_STATUS_TYPE ADD (
  CONSTRAINT CIS_PRVNC_VLDTNSTTSTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_STATUS_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_STATUS_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_RSLT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_RSLT_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_RSLT_H
(
  CIS_VLDTN_RSLT_H_ID            NUMBER(20)     NOT NULL,
  CIS_VLDTN_RSLT_ID              NUMBER(20)     NOT NULL,
  CIS_CONT_INFO_DATA_QUAL_ID     NUMBER(20)     NOT NULL,
  CRCTD_DLVRY_PNT_VLDTN_STTS_ID  NUMBER(20)     NOT NULL,
  CRCTD_STTS_ID                  NUMBER(20)     NOT NULL,
  CRCTD_DATA                     CLOB,
  REC_MDFD_CNT                   NUMBER(18)     NOT NULL,
  REC_CRTR_PARTY_ID              NUMBER(20)     NOT NULL,
  SRC_APLCTN_PARTY_ID            NUMBER(20)     NOT NULL,
  REC_MDFD_TYPE_CD               VARCHAR2(1 BYTE) NOT NULL,
  REC_CRTD_DT                    DATE           DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID              NUMBER(20)     NOT NULL
)
LOB (CRCTD_DATA) STORE AS (
  TABLESPACE  L_CIS_LOB_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.CIS_VLDTN_RSLT_H_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.CRCTD_DATA IS 'Corrected Address - XML format';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_H_PK ON CIS.CIS_VLDTN_RSLT_H
(CIS_VLDTN_RSLT_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_RSLT_H FOR CIS.CIS_VLDTN_RSLT_H;


ALTER TABLE CIS.CIS_VLDTN_RSLT_H ADD (
  CONSTRAINT CIS_VLDTN_RSLT_H_PK
  PRIMARY KEY
  (CIS_VLDTN_RSLT_H_ID)
  USING INDEX CIS.CIS_VLDTN_RSLT_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_RSLT_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT_H TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_RSLT_CLOB_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_RSLT_CLOB_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_RSLT_CLOB_H
(
  CIS_VLDTN_RSLT_CLOB_H_ID  NUMBER(20)          NOT NULL,
  CIS_VLDTN_RSLT_ID         NUMBER(20)          NOT NULL,
  CRCTD_DATA                CLOB,
  REC_CRTR_PARTY_ID         NUMBER(20)          NOT NULL,
  SRC_APLCTN_PARTY_ID       NUMBER(20)          NOT NULL,
  REC_MDFD_TYPE_CD          VARCHAR2(1 BYTE)    NOT NULL,
  REC_CRTD_DT               DATE                DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
LOB (CRCTD_DATA) STORE AS (
  TABLESPACE  L_CIS_LOB_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_CLOB_H.CRCTD_DATA IS 'Corrected Address - XML format';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_CLOB_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_CLOB_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_CLOB_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_CLOB_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_CLOB_H_PK ON CIS.CIS_VLDTN_RSLT_CLOB_H
(CIS_VLDTN_RSLT_CLOB_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_RSLT_CLOB_H FOR CIS.CIS_VLDTN_RSLT_CLOB_H;


ALTER TABLE CIS.CIS_VLDTN_RSLT_CLOB_H ADD (
  CONSTRAINT CIS_VLDTN_RSLT_CLOB_H_PK
  PRIMARY KEY
  (CIS_VLDTN_RSLT_CLOB_H_ID)
  USING INDEX CIS.CIS_VLDTN_RSLT_CLOB_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_RSLT_CLOB_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT_CLOB_H TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_RSLT_CLOB
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_RSLT_CLOB CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_RSLT_CLOB
(
  CIS_VLDTN_RSLT_ID  NUMBER(20)                 NOT NULL,
  CRCTD_DATA         CLOB,
  CIS_PROVENANCE_ID  NUMBER(20)                 NOT NULL
)
LOB (CRCTD_DATA) STORE AS (
  TABLESPACE  L_CIS_LOB_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT_CLOB.CRCTD_DATA IS 'Corrected Address - XML format';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_CLOB_PFK ON CIS.CIS_VLDTN_RSLT_CLOB
(CIS_VLDTN_RSLT_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_RSLT_CLOB_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_RSLT_CLOB
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_RSLT_CLOB_H( CIS_VLDTN_RSLT_CLOB_H_ID,

CIS_VLDTN_RSLT_ID,

CRCTD_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_CLOB_H_S.nextval
,

:old.CIS_VLDTN_RSLT_ID,

:old.CRCTD_DATA,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,
'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_RSLT_CLOB_H( CIS_VLDTN_RSLT_CLOB_H_ID,

CIS_VLDTN_RSLT_ID,

CRCTD_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_CLOB_H_S.nextval
,

:new.CIS_VLDTN_RSLT_ID,

:new.CRCTD_DATA,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,
mDML);
end if;
end CIS_VLDTN_RSLT_CLOB_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_RSLT_CLOB FOR CIS.CIS_VLDTN_RSLT_CLOB;


ALTER TABLE CIS.CIS_VLDTN_RSLT_CLOB ADD (
  CONSTRAINT CIS_VLDTN_RSLT_CLOB_PFK
  PRIMARY KEY
  (CIS_VLDTN_RSLT_ID)
  USING INDEX CIS.CIS_VLDTN_RSLT_CLOB_PFK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_VLDTN_RSLT_CLOB ADD (
  CONSTRAINT CIS_PRVNC_VLDTNRSLTCLOB_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTN_RSLT_CLOB_FK 
  FOREIGN KEY (CIS_VLDTN_RSLT_ID) 
  REFERENCES CIS.CIS_VLDTN_RSLT (CIS_VLDTN_RSLT_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_RSLT_CLOB TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT_CLOB TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_RSLT
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_RSLT CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_RSLT
(
  CIS_VLDTN_RSLT_ID              NUMBER(20)     NOT NULL,
  CIS_CONT_INFO_DATA_QUAL_ID     NUMBER(20)     NOT NULL,
  CRCTD_DLVRY_PNT_VLDTN_STTS_ID  NUMBER(20)     NOT NULL,
  CRCTD_STTS_ID                  NUMBER(20)     NOT NULL,
  CRCTD_DATA                     CLOB,
  REC_MDFD_CNT                   NUMBER(18)     NOT NULL,
  CIS_PROVENANCE_ID              NUMBER(20)     NOT NULL
)
LOB (CRCTD_DATA) STORE AS (
  TABLESPACE  L_CIS_LOB_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT.CIS_VLDTN_RSLT_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT.CRCTD_DLVRY_PNT_VLDTN_STTS_ID IS 'Corrected Delivery Point Validation Status - Currently Valid/Invalid are the valid types';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT.CRCTD_STTS_ID IS 'Corrected  Status Type - Currently Valid/Invalid OR YES/NO are the valid types';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT.CRCTD_DATA IS 'Corrected Address - XML format';

COMMENT ON COLUMN CIS.CIS_VLDTN_RSLT.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE INDEX CIS.CIS_CI_DQ_VLDTN_RSLT_FK_I ON CIS.CIS_VLDTN_RSLT
(CIS_CONT_INFO_DATA_QUAL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_VLDTNSTTS_RSLT_DLYPNT_FK_I ON CIS.CIS_VLDTN_RSLT
(CRCTD_DLVRY_PNT_VLDTN_STTS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_VLDTNST_RSLT_CRCTDST_FK_I ON CIS.CIS_VLDTN_RSLT
(CRCTD_STTS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_RSLT_PK ON CIS.CIS_VLDTN_RSLT
(CIS_VLDTN_RSLT_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_RSLT_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_RSLT
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_RSLT_H( CIS_VLDTN_RSLT_H_ID,

CIS_VLDTN_RSLT_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

CRCTD_STTS_ID,

CRCTD_DATA,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_H_S.nextval
,

:old.CIS_VLDTN_RSLT_ID,

:old.CIS_CONT_INFO_DATA_QUAL_ID,

:old.CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

:old.CRCTD_STTS_ID,

:old.CRCTD_DATA,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_RSLT_H( CIS_VLDTN_RSLT_H_ID,

CIS_VLDTN_RSLT_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

CRCTD_STTS_ID,

CRCTD_DATA,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_RSLT_H_S.nextval
,

:new.CIS_VLDTN_RSLT_ID,

:new.CIS_CONT_INFO_DATA_QUAL_ID,

:new.CRCTD_DLVRY_PNT_VLDTN_STTS_ID,

:new.CRCTD_STTS_ID,

:new.CRCTD_DATA,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_VLDTN_RSLT_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_RSLT FOR CIS.CIS_VLDTN_RSLT;


ALTER TABLE CIS.CIS_VLDTN_RSLT ADD (
  CONSTRAINT CIS_VLDTN_RSLT_PK
  PRIMARY KEY
  (CIS_VLDTN_RSLT_ID)
  USING INDEX CIS.CIS_VLDTN_RSLT_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_VLDTN_RSLT ADD (
  CONSTRAINT CIS_CI_DQ_VLDTN_RSLT_FK 
  FOREIGN KEY (CIS_CONT_INFO_DATA_QUAL_ID) 
  REFERENCES CIS.CIS_CONT_INFO_DATA_QUALITY (CIS_CONT_INFO_DATA_QUAL_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_VLDTNRSLT_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTNSTTS_RSLT_CRCTDSTS_FK 
  FOREIGN KEY (CRCTD_STTS_ID) 
  REFERENCES CIS.CIS_VLDTN_STATUS_TYPE (CIS_VLDTN_STATUS_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTNSTTS_RSLT_DLVRYPNT_FK 
  FOREIGN KEY (CRCTD_DLVRY_PNT_VLDTN_STTS_ID) 
  REFERENCES CIS.CIS_VLDTN_STATUS_TYPE (CIS_VLDTN_STATUS_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_RSLT TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_RSLT TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_PRBLM_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_PRBLM_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_PRBLM_TYPE_H
(
  CIS_VLDTN_PRBLM_TYPE_H_ID  NUMBER(20)         NOT NULL,
  CIS_VLDTN_PRBLM_TYPE_ID    NUMBER(20)         NOT NULL,
  VLDTN_PRBLM_TYPE_CD        VARCHAR2(30 BYTE)  NOT NULL,
  VLDTN_PRBLM_TYPE_NM        VARCHAR2(50 BYTE)  NOT NULL,
  VLDTN_PRBLM_TYPE_DESC_TX   VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT               NUMBER(18)         NOT NULL,
  REC_CRTR_PARTY_ID          NUMBER(20)         NOT NULL,
  SRC_APLCTN_PARTY_ID        NUMBER(20)         NOT NULL,
  REC_MDFD_TYPE_CD           VARCHAR2(1 BYTE)   NOT NULL,
  REC_CRTD_DT                DATE               DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID          NUMBER(20)         NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.CIS_VLDTN_PRBLM_TYPE_H_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.VLDTN_PRBLM_TYPE_CD IS 'Type Code';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.VLDTN_PRBLM_TYPE_NM IS 'Type Name';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.VLDTN_PRBLM_TYPE_DESC_TX IS 'Long Descriptive text';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_PRBLM_TYPE_H_PK ON CIS.CIS_VLDTN_PRBLM_TYPE_H
(CIS_VLDTN_PRBLM_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_PRBLM_TYPE_H FOR CIS.CIS_VLDTN_PRBLM_TYPE_H;


ALTER TABLE CIS.CIS_VLDTN_PRBLM_TYPE_H ADD (
  CONSTRAINT CIS_VLDTN_PRBLM_TYPE_H_PK
  PRIMARY KEY
  (CIS_VLDTN_PRBLM_TYPE_H_ID)
  USING INDEX CIS.CIS_VLDTN_PRBLM_TYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_PRBLM_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_PRBLM_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_PRBLM_TYPE
(
  CIS_VLDTN_PRBLM_TYPE_ID   NUMBER(20)          NOT NULL,
  VLDTN_PRBLM_TYPE_CD       VARCHAR2(30 BYTE)   NOT NULL,
  VLDTN_PRBLM_TYPE_NM       VARCHAR2(50 BYTE)   NOT NULL,
  VLDTN_PRBLM_TYPE_DESC_TX  VARCHAR2(100 BYTE)  NOT NULL,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE.CIS_VLDTN_PRBLM_TYPE_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE.VLDTN_PRBLM_TYPE_CD IS 'Type Code';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE.VLDTN_PRBLM_TYPE_NM IS 'Type Name';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE.VLDTN_PRBLM_TYPE_DESC_TX IS 'Long Descriptive text';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_VLDTN_PRBLM_TYPE_PK ON CIS.CIS_VLDTN_PRBLM_TYPE
(CIS_VLDTN_PRBLM_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_VLDTN_PRBLM_TYPE_UK_I ON CIS.CIS_VLDTN_PRBLM_TYPE
(VLDTN_PRBLM_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_PRBLM_TYP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_PRBLM_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_PRBLM_TYPE_H( CIS_VLDTN_PRBLM_TYPE_H_ID,

CIS_VLDTN_PRBLM_TYPE_ID,

VLDTN_PRBLM_TYPE_CD,


VLDTN_PRBLM_TYPE_NM,

VLDTN_PRBLM_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_PRBLM_TYPE_H_S.nextval
,

:old.CIS_VLDTN_PRBLM_TYPE_ID,

:old.VLDTN_PRBLM_TYPE_CD,

:old.VLDTN_PRBLM_TYPE_NM,

:old.VLDTN_PRBLM_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_PRBLM_TYPE_H( CIS_VLDTN_PRBLM_TYPE_H_ID,

CIS_VLDTN_PRBLM_TYPE_ID,

VLDTN_PRBLM_TYPE_CD,


VLDTN_PRBLM_TYPE_NM,

VLDTN_PRBLM_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_VLDTN_PRBLM_TYPE_H_S.nextval
,

:new.CIS_VLDTN_PRBLM_TYPE_ID,

:new.VLDTN_PRBLM_TYPE_CD,

:new.VLDTN_PRBLM_TYPE_NM,

:new.VLDTN_PRBLM_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_VLDTN_PRBLM_TYP_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_PRBLM_TYPE FOR CIS.CIS_VLDTN_PRBLM_TYPE;


ALTER TABLE CIS.CIS_VLDTN_PRBLM_TYPE ADD (
  CONSTRAINT CIS_VLDTN_PRBLM_TYPE_PK
  PRIMARY KEY
  (CIS_VLDTN_PRBLM_TYPE_ID)
  USING INDEX CIS.CIS_VLDTN_PRBLM_TYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTN_PRBLM_TYPE_UK
  UNIQUE (VLDTN_PRBLM_TYPE_CD)
  USING INDEX CIS.CIS_VLDTN_PRBLM_TYPE_UK_I
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_VLDTN_PRBLM_TYPE ADD (
  CONSTRAINT CIS_PRVNC_VLDTNPRBLMTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_PRBLM_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_PRBLM_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_PRBLM_H
(
  CIS_VLDTN_PRBLM_H_ID     NUMBER(20)           NOT NULL,
  CIS_VLDTN_PRBLM_ID       NUMBER(20)           NOT NULL,
  CIS_VLDTN_RSLT_ID        NUMBER(20)           NOT NULL,
  CIS_VLDTN_PRBLM_TYPE_ID  NUMBER(20)           NOT NULL,
  REC_MDFD_CNT             NUMBER(18)           NOT NULL,
  REC_CRTR_PARTY_ID        NUMBER(20)           NOT NULL,
  SRC_APLCTN_PARTY_ID      NUMBER(20)           NOT NULL,
  REC_MDFD_TYPE_CD         VARCHAR2(1 BYTE)     NOT NULL,
  REC_CRTD_DT              DATE                 DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID        NUMBER(20)           NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_H.CIS_VLDTN_PRBLM_H_ID IS 'Surrogate key';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE INDEX CIS.CIS_VLDTN_PRBLM_H_PK ON CIS.CIS_VLDTN_PRBLM_H
(CIS_VLDTN_PRBLM_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_PRBLM_H FOR CIS.CIS_VLDTN_PRBLM_H;


ALTER TABLE CIS.CIS_VLDTN_PRBLM_H ADD (
  CONSTRAINT CIS_VLDTN_PRBLM_H_PK
  PRIMARY KEY
  (CIS_VLDTN_PRBLM_H_ID)
  USING INDEX CIS.CIS_VLDTN_PRBLM_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_PRBLM_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM_H TO CIS_RW;
ALTER TABLE CIS.CIS_VLDTN_PRBLM
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_VLDTN_PRBLM CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_VLDTN_PRBLM
(
  CIS_VLDTN_PRBLM_ID       NUMBER(20)           NOT NULL,
  CIS_VLDTN_RSLT_ID        NUMBER(20)           NOT NULL,
  CIS_VLDTN_PRBLM_TYPE_ID  NUMBER(20)           NOT NULL,
  REC_MDFD_CNT             NUMBER(18)           NOT NULL,
  CIS_PROVENANCE_ID        NUMBER(20)           NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM.CIS_VLDTN_PRBLM_ID IS 'Surrogate key';

COMMENT ON COLUMN CIS.CIS_VLDTN_PRBLM.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE INDEX CIS.CIS_VLDTNRSLT_VLDTNPRBLM_FK_I ON CIS.CIS_VLDTN_PRBLM
(CIS_VLDTN_RSLT_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_VLDTN_PRBLM_PK ON CIS.CIS_VLDTN_PRBLM
(CIS_VLDTN_PRBLM_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_VLDTN_PRBLM_TY_PRBLM_FK_I ON CIS.CIS_VLDTN_PRBLM
(CIS_VLDTN_PRBLM_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_VLDTN_PRBLM_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_VLDTN_PRBLM
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_PRBLM_H( CIS_VLDTN_PRBLM_H_ID,

CIS_VLDTN_PRBLM_ID,

CIS_VLDTN_RSLT_ID,

CIS_VLDTN_PRBLM_TYPE_ID,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_VLDTN_PRBLM_H_S.nextval
,

:old.CIS_VLDTN_PRBLM_ID,

:old.CIS_VLDTN_RSLT_ID,

:old.CIS_VLDTN_PRBLM_TYPE_ID,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_VLDTN_PRBLM_H( CIS_VLDTN_PRBLM_H_ID,

CIS_VLDTN_PRBLM_ID,

CIS_VLDTN_RSLT_ID,

CIS_VLDTN_PRBLM_TYPE_ID,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_VLDTN_PRBLM_H_S.nextval
,

:new.CIS_VLDTN_PRBLM_ID,

:new.CIS_VLDTN_RSLT_ID,

:new.CIS_VLDTN_PRBLM_TYPE_ID,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_VLDTN_PRBLM_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_VLDTN_PRBLM FOR CIS.CIS_VLDTN_PRBLM;


ALTER TABLE CIS.CIS_VLDTN_PRBLM ADD (
  CONSTRAINT CIS_VLDTN_PRBLM_PK
  PRIMARY KEY
  (CIS_VLDTN_PRBLM_ID)
  USING INDEX CIS.CIS_VLDTN_PRBLM_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_VLDTN_PRBLM ADD (
  CONSTRAINT CIS_PRVNC_VLDTNPRBLM_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTNRSLT_VLDTNPROBLEM_FK 
  FOREIGN KEY (CIS_VLDTN_RSLT_ID) 
  REFERENCES CIS.CIS_VLDTN_RSLT (CIS_VLDTN_RSLT_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_VLDTN_PRBLM_TY_PRBLM_FK 
  FOREIGN KEY (CIS_VLDTN_PRBLM_TYPE_ID) 
  REFERENCES CIS.CIS_VLDTN_PRBLM_TYPE (CIS_VLDTN_PRBLM_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_VLDTN_PRBLM TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_VLDTN_PRBLM TO CIS_RW;
ALTER TABLE CIS.CIS_STAT_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_STAT_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_STAT_TYPE_H
(
  CIS_STAT_TYPE_H_ID   NUMBER(20)               NOT NULL,
  CIS_STAT_TYPE_ID     NUMBER(20)               NOT NULL,
  STAT_TYPE_CD         VARCHAR2(5 BYTE)         NOT NULL,
  STAT_TYPE_NM         VARCHAR2(30 BYTE)        NOT NULL,
  STAT_TYPE_DESC_TX    VARCHAR2(100 BYTE)       NOT NULL,
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20)               NOT NULL,
  REC_MDFD_TYPE_CD     VARCHAR2(1 BYTE)         NOT NULL,
  REC_CRTD_DT          DATE                     DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_STAT_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_STAT_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_STAT_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_STAT_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_STAT_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_STATTYPE_H_PK ON CIS.CIS_STAT_TYPE_H
(CIS_STAT_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_STAT_TYPE_H FOR CIS.CIS_STAT_TYPE_H;


ALTER TABLE CIS.CIS_STAT_TYPE_H ADD (
  CONSTRAINT CIS_STATTYPE_H_PK
  PRIMARY KEY
  (CIS_STAT_TYPE_H_ID)
  USING INDEX CIS.CIS_STATTYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_STAT_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_STAT_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_STAT_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_STAT_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_STAT_TYPE
(
  CIS_STAT_TYPE_ID   NUMBER(20)                 NOT NULL,
  STAT_TYPE_CD       VARCHAR2(5 BYTE)           NOT NULL,
  STAT_TYPE_NM       VARCHAR2(30 BYTE)          NOT NULL,
  STAT_TYPE_DESC_TX  VARCHAR2(100 BYTE)         NOT NULL,
  REC_MDFD_CNT       NUMBER(18)                 NOT NULL,
  CIS_PROVENANCE_ID  NUMBER(20)                 NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_STAT_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_STATTYPE_CD_UK ON CIS.CIS_STAT_TYPE
(STAT_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_STATTYPE_PK ON CIS.CIS_STAT_TYPE
(CIS_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_STAT_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_STAT_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_STAT_TYPE_H( CIS_STAT_TYPE_H_ID,

CIS_STAT_TYPE_ID,

STAT_TYPE_CD,

STAT_TYPE_NM,

STAT_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_STAT_TYPE_H_S.nextval
,

:old.CIS_STAT_TYPE_ID,

:old.STAT_TYPE_CD,

:old.STAT_TYPE_NM,

:old.STAT_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_STAT_TYPE_H( CIS_STAT_TYPE_H_ID,

CIS_STAT_TYPE_ID,

STAT_TYPE_CD,

STAT_TYPE_NM,

STAT_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_STAT_TYPE_H_S.nextval
,

:new.CIS_STAT_TYPE_ID,

:new.STAT_TYPE_CD,

:new.STAT_TYPE_NM,

:new.STAT_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_STAT_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_STAT_TYPE FOR CIS.CIS_STAT_TYPE;


ALTER TABLE CIS.CIS_STAT_TYPE ADD (
  CONSTRAINT CIS_STATTYPE_PK
  PRIMARY KEY
  (CIS_STAT_TYPE_ID)
  USING INDEX CIS.CIS_STATTYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_STATTYPE_CD_UK
  UNIQUE (STAT_TYPE_CD)
  USING INDEX CIS.CIS_STATTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_STAT_TYPE ADD (
  CONSTRAINT CIS_PRVNC_STATTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_STAT_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_STAT_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_RULE_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_RULE_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_RULE_TYPE_H
(
  CIS_RULE_TYPE_H_ID   NUMBER(20)               NOT NULL,
  CIS_RULE_TYPE_ID     NUMBER(20)               NOT NULL,
  RULE_TYPE_CD         VARCHAR2(5 BYTE)         NOT NULL,
  RULE_TYPE_NM         VARCHAR2(30 BYTE)        NOT NULL,
  RULE_TYPE_DESC_TX    VARCHAR2(100 BYTE)       NOT NULL,
  RULE_VERSION_TX      VARCHAR2(10 BYTE),
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20)               NOT NULL,
  REC_MDFD_TYPE_CD     VARCHAR2(1 BYTE)         NOT NULL,
  REC_CRTD_DT          DATE                     DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_RULE_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_RULE_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_RULE_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_RULE_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_RULE_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_RULETYPE_H_PK ON CIS.CIS_RULE_TYPE_H
(CIS_RULE_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_RULE_TYPE_H FOR CIS.CIS_RULE_TYPE_H;


ALTER TABLE CIS.CIS_RULE_TYPE_H ADD (
  CONSTRAINT CIS_RULETYPE_H_PK
  PRIMARY KEY
  (CIS_RULE_TYPE_H_ID)
  USING INDEX CIS.CIS_RULETYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_RULE_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_RULE_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_RULE_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_RULE_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_RULE_TYPE
(
  CIS_RULE_TYPE_ID   NUMBER(20)                 NOT NULL,
  RULE_TYPE_CD       VARCHAR2(5 BYTE)           NOT NULL,
  RULE_TYPE_NM       VARCHAR2(30 BYTE)          NOT NULL,
  RULE_TYPE_DESC_TX  VARCHAR2(100 BYTE)         NOT NULL,
  RULE_VERSION_TX    VARCHAR2(10 BYTE),
  REC_MDFD_CNT       NUMBER(18)                 NOT NULL,
  CIS_PROVENANCE_ID  NUMBER(20)                 NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_RULE_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_RULETYPE_CD_UK ON CIS.CIS_RULE_TYPE
(RULE_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_RULETYPE_PK ON CIS.CIS_RULE_TYPE
(CIS_RULE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_RULE_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_RULE_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_RULE_TYPE_H( CIS_RULE_TYPE_H_ID,

CIS_RULE_TYPE_ID,

RULE_TYPE_CD,

RULE_TYPE_NM,

RULE_TYPE_DESC_TX,


RULE_VERSION_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_RULE_TYPE_H_S.nextval
,

:old.CIS_RULE_TYPE_ID,

:old.RULE_TYPE_CD,

:old.RULE_TYPE_NM,

:old.RULE_TYPE_DESC_TX,

:old.RULE_VERSION_TX,

:old.REC_MDFD_CNT
,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_RULE_TYPE_H( CIS_RULE_TYPE_H_ID,

CIS_RULE_TYPE_ID,

RULE_TYPE_CD,

RULE_TYPE_NM,

RULE_TYPE_DESC_TX,


RULE_VERSION_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_RULE_TYPE_H_S.nextval
,

:new.CIS_RULE_TYPE_ID,

:new.RULE_TYPE_CD,

:new.RULE_TYPE_NM,

:new.RULE_TYPE_DESC_TX,

:new.RULE_VERSION_TX,

:new.REC_MDFD_CNT
,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_RULE_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_RULE_TYPE FOR CIS.CIS_RULE_TYPE;


ALTER TABLE CIS.CIS_RULE_TYPE ADD (
  CONSTRAINT CIS_RULETYPE_PK
  PRIMARY KEY
  (CIS_RULE_TYPE_ID)
  USING INDEX CIS.CIS_RULETYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_RULETYPE_CD_UK
  UNIQUE (RULE_TYPE_CD)
  USING INDEX CIS.CIS_RULETYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_RULE_TYPE ADD (
  CONSTRAINT CIS_PRVNC_RULETY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_RULE_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_RULE_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_PURPOSE_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PURPOSE_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PURPOSE_TYPE_H
(
  CIS_PURP_TYPE_H_ID   NUMBER(20)               NOT NULL,
  CIS_PURP_TYPE_ID     NUMBER(20)               NOT NULL,
  PURP_TYPE_CD         VARCHAR2(5 BYTE)         NOT NULL,
  PURP_TYPE_NM         VARCHAR2(30 BYTE)        NOT NULL,
  PURP_TYPE_DESC_TX    VARCHAR2(100 BYTE)       NOT NULL,
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20)               NOT NULL,
  REC_MDFD_TYPE_CD     VARCHAR2(1 BYTE)         NOT NULL,
  REC_CRTD_DT          DATE                     DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PURPOSE_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PURPOSE_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PURPOSE_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PURPOSE_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PURPOSE_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PURPOSETYPE_H_PK ON CIS.CIS_PURPOSE_TYPE_H
(CIS_PURP_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PURPOSE_TYPE_H FOR CIS.CIS_PURPOSE_TYPE_H;


ALTER TABLE CIS.CIS_PURPOSE_TYPE_H ADD (
  CONSTRAINT CIS_PURPOSETYPE_H_PK
  PRIMARY KEY
  (CIS_PURP_TYPE_H_ID)
  USING INDEX CIS.CIS_PURPOSETYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PURPOSE_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PURPOSE_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_PURPOSE_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PURPOSE_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PURPOSE_TYPE
(
  CIS_PURP_TYPE_ID   NUMBER(20)                 NOT NULL,
  PURP_TYPE_CD       VARCHAR2(5 BYTE)           NOT NULL,
  PURP_TYPE_NM       VARCHAR2(30 BYTE)          NOT NULL,
  PURP_TYPE_DESC_TX  VARCHAR2(100 BYTE)         NOT NULL,
  REC_MDFD_CNT       NUMBER(18)                 NOT NULL,
  CIS_PROVENANCE_ID  NUMBER(20)                 NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PURPOSE_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PURPOSETYPE_PK ON CIS.CIS_PURPOSE_TYPE
(CIS_PURP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PURPOSEYPE_CD_UK ON CIS.CIS_PURPOSE_TYPE
(PURP_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PURPOSE_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PURPOSE_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PURPOSE_TYPE_H( CIS_PURP_TYPE_H_ID,

CIS_PURP_TYPE_ID,

PURP_TYPE_CD,

PURP_TYPE_NM,

PURP_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PURPOSE_TYPE_H_S.nextval
,

:old.CIS_PURP_TYPE_ID,

:old.PURP_TYPE_CD,

:old.PURP_TYPE_NM,

:old.PURP_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PURPOSE_TYPE_H( CIS_PURP_TYPE_H_ID,

CIS_PURP_TYPE_ID,

PURP_TYPE_CD,

PURP_TYPE_NM,

PURP_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PURPOSE_TYPE_H_S.nextval
,

:new.CIS_PURP_TYPE_ID,

:new.PURP_TYPE_CD,

:new.PURP_TYPE_NM,

:new.PURP_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PURPOSE_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PURPOSE_TYPE FOR CIS.CIS_PURPOSE_TYPE;


ALTER TABLE CIS.CIS_PURPOSE_TYPE ADD (
  CONSTRAINT CIS_PURPOSETYPE_PK
  PRIMARY KEY
  (CIS_PURP_TYPE_ID)
  USING INDEX CIS.CIS_PURPOSETYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PURPOSEYPE_CD_UK
  UNIQUE (PURP_TYPE_CD)
  USING INDEX CIS.CIS_PURPOSEYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PURPOSE_TYPE ADD (
  CONSTRAINT CIS_PRVNC_PRPSTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PURPOSE_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PURPOSE_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_PROVENANCE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PROVENANCE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PROVENANCE
(
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20),
  PROCESS_NM           VARCHAR2(50 BYTE)        NOT NULL,
  REC_CRTD_DT          DATE                     NOT NULL,
  SRC_FORM_NM          VARCHAR2(100 BYTE)
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_PROVENANCE IS 'This table holds the provenance information for every tables/Process. Whenever any CIS_ table is updated (insert/update/delete), except history (_H) tables, individually or in a group a row is inserted into this table. e.g. If a contact info is created by CIS service, one row will be created in this table and that cis_provenance_id will be used by all tables updated by the service, to list few - cont_info, cont_info_address, cont_info_purpose,....
If any table is updated directly (non-standard way or admin service), a row will be created into this table and that id will be used as provenance for the table which is updated directly.';

COMMENT ON COLUMN CIS.CIS_PROVENANCE.REC_CRTR_PARTY_ID IS 'Party who created the record';

COMMENT ON COLUMN CIS.CIS_PROVENANCE.SRC_APLCTN_PARTY_ID IS 'Party Id of Application which last inserted/ modified  the record';

COMMENT ON COLUMN CIS.CIS_PROVENANCE.PROCESS_NM IS 'This column contains the name of the CIS Process that created this row. ex Contact Info Create or Contact Info Update ';

COMMENT ON COLUMN CIS.CIS_PROVENANCE.REC_CRTD_DT IS 'DateTime stamp when the record was created. Populated by DB in pre-insert trigger with SYSDATE';

COMMENT ON COLUMN CIS.CIS_PROVENANCE.SRC_FORM_NM IS 'Form which was used (in source application) to update the data';


CREATE INDEX CIS.CIS_PARTY_PRVNNCE_APLCTN_FK_I ON CIS.CIS_PROVENANCE
(SRC_APLCTN_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTY_PRVNNCE_CRTR_FK_I ON CIS.CIS_PROVENANCE
(REC_CRTR_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PROVENANCE_PK ON CIS.CIS_PROVENANCE
(CIS_PROVENANCE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PROVENANCE_BIUR_TRGR
  BEFORE INSERT OR UPDATE
  ON CIS.CIS_PROVENANCE
 FOR EACH ROW
declare
mDML char(1) ;
begin
:new.REC_CRTD_DT:=sysdate;
END;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PROVENANCE FOR CIS.CIS_PROVENANCE;


ALTER TABLE CIS.CIS_PROVENANCE ADD (
  CONSTRAINT CIS_PROVENANCE_PK
  PRIMARY KEY
  (CIS_PROVENANCE_ID)
  USING INDEX CIS.CIS_PROVENANCE_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PROVENANCE ADD (
  CONSTRAINT CIS_PARTY_PRVNNCE_APLCTN_FK 
  FOREIGN KEY (SRC_APLCTN_PARTY_ID) 
  REFERENCES CIS.CIS_PARTY (CIS_PARTY_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTY_PRVNNCE_CRTR_FK 
  FOREIGN KEY (REC_CRTR_PARTY_ID) 
  REFERENCES CIS.CIS_PARTY (CIS_PARTY_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PROVENANCE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PROVENANCE TO CIS_RW;
ALTER TABLE CIS.CIS_PREF_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PREF_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PREF_TYPE_H
(
  CIS_PREF_TYPE_H_ID   NUMBER(20)               NOT NULL,
  CIS_PREF_TYPE_ID     NUMBER(20)               NOT NULL,
  PREF_TYPE_CD         VARCHAR2(5 BYTE)         NOT NULL,
  PREF_TYPE_NM         VARCHAR2(30 BYTE)        NOT NULL,
  PREF_TYPE_DESC_TX    VARCHAR2(100 BYTE)       NOT NULL,
  PREF_DOMAIN_TX       VARCHAR2(30 BYTE),
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20)               NOT NULL,
  REC_MDFD_TYPE_CD     VARCHAR2(1 BYTE)         NOT NULL,
  REC_CRTD_DT          DATE                     DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PREF_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PREF_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PREF_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PREF_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PREF_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PREFTYPECD_H_PK ON CIS.CIS_PREF_TYPE_H
(CIS_PREF_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PREF_TYPE_H FOR CIS.CIS_PREF_TYPE_H;


ALTER TABLE CIS.CIS_PREF_TYPE_H ADD (
  CONSTRAINT CIS_PREFTYPECD_H_PK
  PRIMARY KEY
  (CIS_PREF_TYPE_H_ID)
  USING INDEX CIS.CIS_PREFTYPECD_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PREF_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PREF_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_PREF_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PREF_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PREF_TYPE
(
  CIS_PREF_TYPE_ID   NUMBER(20)                 NOT NULL,
  PREF_TYPE_CD       VARCHAR2(5 BYTE)           NOT NULL,
  PREF_TYPE_NM       VARCHAR2(30 BYTE)          NOT NULL,
  PREF_TYPE_DESC_TX  VARCHAR2(100 BYTE)         NOT NULL,
  PREF_DOMAIN_TX     VARCHAR2(30 BYTE),
  REC_MDFD_CNT       NUMBER(18)                 NOT NULL,
  CIS_PROVENANCE_ID  NUMBER(20)                 NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PREF_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PREFTYPECD_PK ON CIS.CIS_PREF_TYPE
(CIS_PREF_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PREFTYPE_CD_UK ON CIS.CIS_PREF_TYPE
(PREF_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PREF_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PREF_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PREF_TYPE_H( CIS_PREF_TYPE_H_ID,

CIS_PREF_TYPE_ID,

PREF_TYPE_CD,

PREF_TYPE_NM,

PREF_TYPE_DESC_TX,


PREF_DOMAIN_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_PREF_TYPE_H_S.nextval
,

:old.CIS_PREF_TYPE_ID,

:old.PREF_TYPE_CD,

:old.PREF_TYPE_NM,

:old.PREF_TYPE_DESC_TX,

:old.PREF_DOMAIN_TX,

:old.REC_MDFD_CNT,


:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PREF_TYPE_H( CIS_PREF_TYPE_H_ID,

CIS_PREF_TYPE_ID,

PREF_TYPE_CD,

PREF_TYPE_NM,

PREF_TYPE_DESC_TX,


PREF_DOMAIN_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_PREF_TYPE_H_S.nextval
,

:new.CIS_PREF_TYPE_ID,

:new.PREF_TYPE_CD,

:new.PREF_TYPE_NM,

:new.PREF_TYPE_DESC_TX,

:new.PREF_DOMAIN_TX,

:new.REC_MDFD_CNT,


:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PREF_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PREF_TYPE FOR CIS.CIS_PREF_TYPE;


ALTER TABLE CIS.CIS_PREF_TYPE ADD (
  CONSTRAINT CIS_PREFTYPECD_PK
  PRIMARY KEY
  (CIS_PREF_TYPE_ID)
  USING INDEX CIS.CIS_PREFTYPECD_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PREFTYPE_CD_UK
  UNIQUE (PREF_TYPE_CD)
  USING INDEX CIS.CIS_PREFTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PREF_TYPE ADD (
  CONSTRAINT CIS_PRVNC_PREFTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PREF_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PREF_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_PHONE_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PHONE_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PHONE_TYPE_H
(
  CIS_PHONE_TYPE_H_ID  NUMBER(20)               NOT NULL,
  CIS_PHONE_TYPE_ID    NUMBER(20)               NOT NULL,
  PHONE_TYPE_CD        VARCHAR2(5 BYTE)         NOT NULL,
  PHONE_TYPE_NM        VARCHAR2(30 BYTE)        NOT NULL,
  PHONE_TYPE_DESC_TX   VARCHAR2(100 BYTE)       NOT NULL,
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20)               NOT NULL,
  REC_MDFD_TYPE_CD     VARCHAR2(1 BYTE)         NOT NULL,
  REC_CRTD_DT          DATE                     DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PHONE_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PHONE_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PHONE_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PHONE_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PHONE_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PHONETYPE_H_PK ON CIS.CIS_PHONE_TYPE_H
(CIS_PHONE_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PHONE_TYPE_H FOR CIS.CIS_PHONE_TYPE_H;


ALTER TABLE CIS.CIS_PHONE_TYPE_H ADD (
  CONSTRAINT CIS_PHONETYPE_H_PK
  PRIMARY KEY
  (CIS_PHONE_TYPE_H_ID)
  USING INDEX CIS.CIS_PHONETYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PHONE_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PHONE_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_PHONE_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PHONE_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PHONE_TYPE
(
  CIS_PHONE_TYPE_ID   NUMBER(20)                NOT NULL,
  PHONE_TYPE_CD       VARCHAR2(5 BYTE)          NOT NULL,
  PHONE_TYPE_NM       VARCHAR2(30 BYTE)         NOT NULL,
  PHONE_TYPE_DESC_TX  VARCHAR2(100 BYTE)        NOT NULL,
  REC_MDFD_CNT        NUMBER(18)                NOT NULL,
  CIS_PROVENANCE_ID   NUMBER(20)                NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PHONE_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PHONETYPE_CD_UK ON CIS.CIS_PHONE_TYPE
(PHONE_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PHONETYPE_PK ON CIS.CIS_PHONE_TYPE
(CIS_PHONE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PHONE_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PHONE_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PHONE_TYPE_H( CIS_PHONE_TYPE_H_ID,

CIS_PHONE_TYPE_ID,

PHONE_TYPE_CD,

PHONE_TYPE_NM,

PHONE_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PHONE_TYPE_H_S.nextval
,

:old.CIS_PHONE_TYPE_ID,

:old.PHONE_TYPE_CD,

:old.PHONE_TYPE_NM,

:old.PHONE_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PHONE_TYPE_H( CIS_PHONE_TYPE_H_ID,

CIS_PHONE_TYPE_ID,

PHONE_TYPE_CD,

PHONE_TYPE_NM,

PHONE_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_PHONE_TYPE_H_S.nextval
,

:new.CIS_PHONE_TYPE_ID,

:new.PHONE_TYPE_CD,

:new.PHONE_TYPE_NM,

:new.PHONE_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PHONE_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PHONE_TYPE FOR CIS.CIS_PHONE_TYPE;


ALTER TABLE CIS.CIS_PHONE_TYPE ADD (
  CONSTRAINT CIS_PHONETYPE_PK
  PRIMARY KEY
  (CIS_PHONE_TYPE_ID)
  USING INDEX CIS.CIS_PHONETYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PHONETYPE_CD_UK
  UNIQUE (PHONE_TYPE_CD)
  USING INDEX CIS.CIS_PHONETYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PHONE_TYPE ADD (
  CONSTRAINT CIS_PRVNC_PARTYPHNTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PHONE_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PHONE_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_SRC_ID_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_SRC_ID_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_SRC_ID_TYPE_H
(
  CIS_PARTY_SRC_ID_TYPE_H_ID  NUMBER(20)        NOT NULL,
  CIS_PARTY_SRC_ID_TYPE_ID    NUMBER(20)        NOT NULL,
  PARTY_SRC_ID_TYPE_CD        VARCHAR2(5 BYTE)  NOT NULL,
  PARTY_SRC_ID_TYPE_NM        VARCHAR2(30 BYTE) NOT NULL,
  PARTY_SRC_ID_TYPE_DESC_TX   VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  REC_CRTR_PARTY_ID           NUMBER(20)        NOT NULL,
  SRC_APLCTN_PARTY_ID         NUMBER(20)        NOT NULL,
  REC_MDFD_TYPE_CD            VARCHAR2(1 BYTE)  NOT NULL,
  REC_CRTD_DT                 DATE              DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_SRC_ID_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PARTY_SRC_ID_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_SRC_ID_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_SRC_ID_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PARTY_SRC_ID_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PARTY_SRCID_TYPE_H_PK ON CIS.CIS_PARTY_SRC_ID_TYPE_H
(CIS_PARTY_SRC_ID_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_SRC_ID_TYPE_H FOR CIS.CIS_PARTY_SRC_ID_TYPE_H;


ALTER TABLE CIS.CIS_PARTY_SRC_ID_TYPE_H ADD (
  CONSTRAINT CIS_PARTY_SRCID_TYPE_H_PK
  PRIMARY KEY
  (CIS_PARTY_SRC_ID_TYPE_H_ID)
  USING INDEX CIS.CIS_PARTY_SRCID_TYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_SRC_ID_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_SRC_ID_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_SRC_ID_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_SRC_ID_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_SRC_ID_TYPE
(
  CIS_PARTY_SRC_ID_TYPE_ID   NUMBER(20)         NOT NULL,
  PARTY_SRC_ID_TYPE_CD       VARCHAR2(5 BYTE)   NOT NULL,
  PARTY_SRC_ID_TYPE_NM       VARCHAR2(30 BYTE)  NOT NULL,
  PARTY_SRC_ID_TYPE_DESC_TX  VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT               NUMBER(18)         NOT NULL,
  CIS_PROVENANCE_ID          NUMBER(20)         NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_SRC_ID_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PARTYSRCIDTYPE_CD_UK ON CIS.CIS_PARTY_SRC_ID_TYPE
(PARTY_SRC_ID_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PARTYSRCIDTYPE_PK ON CIS.CIS_PARTY_SRC_ID_TYPE
(CIS_PARTY_SRC_ID_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_SRC_ID_TY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_SRC_ID_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_SRC_ID_TYPE_H( CIS_PARTY_SRC_ID_TYPE_H_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID_TYPE_CD,


PARTY_SRC_ID_TYPE_NM,

PARTY_SRC_ID_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_SRC_ID_TYPE_H_S.nextval
,

:old.CIS_PARTY_SRC_ID_TYPE_ID,

:old.PARTY_SRC_ID_TYPE_CD,

:old.PARTY_SRC_ID_TYPE_NM,

:old.PARTY_SRC_ID_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_SRC_ID_TYPE_H( CIS_PARTY_SRC_ID_TYPE_H_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID_TYPE_CD,


PARTY_SRC_ID_TYPE_NM,

PARTY_SRC_ID_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_SRC_ID_TYPE_H_S.nextval
,

:new.CIS_PARTY_SRC_ID_TYPE_ID,

:new.PARTY_SRC_ID_TYPE_CD,

:new.PARTY_SRC_ID_TYPE_NM,

:new.PARTY_SRC_ID_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PARTY_SRC_ID_TY_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_SRC_ID_TYPE FOR CIS.CIS_PARTY_SRC_ID_TYPE;


ALTER TABLE CIS.CIS_PARTY_SRC_ID_TYPE ADD (
  CONSTRAINT CIS_PARTYSRCIDTYPE_PK
  PRIMARY KEY
  (CIS_PARTY_SRC_ID_TYPE_ID)
  USING INDEX CIS.CIS_PARTYSRCIDTYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTYSRCIDTYPE_CD_UK
  UNIQUE (PARTY_SRC_ID_TYPE_CD)
  USING INDEX CIS.CIS_PARTYSRCIDTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PARTY_SRC_ID_TYPE ADD (
  CONSTRAINT CIS_PRVNC_PARTYSRCIDTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_SRC_ID_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_SRC_ID_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_RLNSHP_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_RLNSHP_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_RLNSHP_TYPE_H
(
  CIS_PARTY_RLNSHP_TYPE_H_ID  NUMBER(20)        NOT NULL,
  CIS_PARTY_RLNSHP_TYPE_ID    NUMBER(20)        NOT NULL,
  PARTY_RLNSHP_TYPE_CD        VARCHAR2(5 BYTE)  NOT NULL,
  PARTY_RLNSHP_NM             VARCHAR2(30 BYTE) NOT NULL,
  PARTY_RLNSHP_DESC_TX        VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  REC_CRTR_PARTY_ID           NUMBER(20)        NOT NULL,
  SRC_APLCTN_PARTY_ID         NUMBER(20)        NOT NULL,
  REC_MDFD_TYPE_CD            VARCHAR2(1 BYTE)  NOT NULL,
  REC_CRTD_DT                 DATE              DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PARTYRELATEDTYPE_H_PK ON CIS.CIS_PARTY_RLNSHP_TYPE_H
(CIS_PARTY_RLNSHP_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_RLNSHP_TYPE_H FOR CIS.CIS_PARTY_RLNSHP_TYPE_H;


ALTER TABLE CIS.CIS_PARTY_RLNSHP_TYPE_H ADD (
  CONSTRAINT CIS_PARTYRELATEDTYPE_H_PK
  PRIMARY KEY
  (CIS_PARTY_RLNSHP_TYPE_H_ID)
  USING INDEX CIS.CIS_PARTYRELATEDTYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_RLNSHP_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_RLNSHP_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_RLNSHP_TYPE
(
  CIS_PARTY_RLNSHP_TYPE_ID  NUMBER(20)          NOT NULL,
  PARTY_RLNSHP_TYPE_CD      VARCHAR2(5 BYTE)    NOT NULL,
  PARTY_RLNSHP_NM           VARCHAR2(30 BYTE)   NOT NULL,
  PARTY_RLNSHP_DESC_TX      VARCHAR2(100 BYTE)  NOT NULL,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHPTYPE_CD_UK ON CIS.CIS_PARTY_RLNSHP_TYPE
(PARTY_RLNSHP_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHPTYPE_PK ON CIS.CIS_PARTY_RLNSHP_TYPE
(CIS_PARTY_RLNSHP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_RLNSHP_TY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_RLNSHP_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_RLNSHP_TYPE_H( CIS_PARTY_RLNSHP_TYPE_H_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

PARTY_RLNSHP_TYPE_CD,


PARTY_RLNSHP_NM,

PARTY_RLNSHP_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID
, REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_TYPE_H_S.nextval
,

:old.CIS_PARTY_RLNSHP_TYPE_ID,

:old.PARTY_RLNSHP_TYPE_CD,

:old.PARTY_RLNSHP_NM,

:old.PARTY_RLNSHP_DESC_TX,

:old.REC_MDFD_CNT,


:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_RLNSHP_TYPE_H( CIS_PARTY_RLNSHP_TYPE_H_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

PARTY_RLNSHP_TYPE_CD,


PARTY_RLNSHP_NM,

PARTY_RLNSHP_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID
, REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_TYPE_H_S.nextval
,

:new.CIS_PARTY_RLNSHP_TYPE_ID,

:new.PARTY_RLNSHP_TYPE_CD,

:new.PARTY_RLNSHP_NM,

:new.PARTY_RLNSHP_DESC_TX,

:new.REC_MDFD_CNT,


:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PARTY_RLNSHP_TY_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_RLNSHP_TYPE FOR CIS.CIS_PARTY_RLNSHP_TYPE;


ALTER TABLE CIS.CIS_PARTY_RLNSHP_TYPE ADD (
  CONSTRAINT CIS_PARTYRLNSHPTYPE_PK
  PRIMARY KEY
  (CIS_PARTY_RLNSHP_TYPE_ID)
  USING INDEX CIS.CIS_PARTYRLNSHPTYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTYRLNSHPTYPE_CD_UK
  UNIQUE (PARTY_RLNSHP_TYPE_CD)
  USING INDEX CIS.CIS_PARTYRLNSHPTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PARTY_RLNSHP_TYPE ADD (
  CONSTRAINT CIS_PRVNC_PARTYRLNSHPTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_RLNSHP_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_RLNSHP_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_RLNSHP_H
(
  CIS_PARTY_RLNSHP_H_ID     NUMBER(20)          NOT NULL,
  CIS_PARTY_RLNSHP_ID       NUMBER(20)          NOT NULL,
  CIS_PARTY_RLNSHP_TYPE_ID  NUMBER(20)          NOT NULL,
  CIS_PRI_PARTY_ID          NUMBER(20)          NOT NULL,
  CIS_SEC_PARTY_ID          NUMBER(20)          NOT NULL,
  EFCTV_START_DT            DATE                NOT NULL,
  EFCTV_END_DT              DATE,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  REC_CRTR_PARTY_ID         NUMBER(20)          NOT NULL,
  SRC_APLCTN_PARTY_ID       NUMBER(20)          NOT NULL,
  REC_MDFD_TYPE_CD          VARCHAR2(1 BYTE)    NOT NULL,
  REC_CRTD_DT               DATE                DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PARTYRELSHP_H_PK ON CIS.CIS_PARTY_RLNSHP_H
(CIS_PARTY_RLNSHP_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_RLNSHP_H FOR CIS.CIS_PARTY_RLNSHP_H;


ALTER TABLE CIS.CIS_PARTY_RLNSHP_H ADD (
  CONSTRAINT CIS_PARTYRELSHP_H_PK
  PRIMARY KEY
  (CIS_PARTY_RLNSHP_H_ID)
  USING INDEX CIS.CIS_PARTYRELSHP_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_RLNSHP_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP_H TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_RLNSHP
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_RLNSHP CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_RLNSHP
(
  CIS_PARTY_RLNSHP_ID       NUMBER(20)          NOT NULL,
  CIS_PARTY_RLNSHP_TYPE_ID  NUMBER(20)          NOT NULL,
  CIS_PRI_PARTY_ID          NUMBER(20)          NOT NULL,
  CIS_SEC_PARTY_ID          NUMBER(20)          NOT NULL,
  EFCTV_START_DT            DATE                NOT NULL,
  EFCTV_END_DT              DATE,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_RLNSHP.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHP_PK ON CIS.CIS_PARTY_RLNSHP
(CIS_PARTY_RLNSHP_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PARTYRLNSHP_UK ON CIS.CIS_PARTY_RLNSHP
(CIS_PRI_PARTY_ID, CIS_SEC_PARTY_ID, CIS_PARTY_RLNSHP_TYPE_ID, EFCTV_START_DT)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTY_PARTYRLNSHPPRI_FK_I ON CIS.CIS_PARTY_RLNSHP
(CIS_PRI_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTY_PARTYRLNSHPSEC_FK_I ON CIS.CIS_PARTY_RLNSHP
(CIS_SEC_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTY_RLNTTYP_RLNSHP_FK_I ON CIS.CIS_PARTY_RLNSHP
(CIS_PARTY_RLNSHP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_RLNSHP_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_RLNSHP
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_RLNSHP_H( CIS_PARTY_RLNSHP_H_ID,

CIS_PARTY_RLNSHP_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

CIS_PRI_PARTY_ID,


CIS_SEC_PARTY_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_H_S.nextval
,

:old.CIS_PARTY_RLNSHP_ID,

:old.CIS_PARTY_RLNSHP_TYPE_ID,

:old.CIS_PRI_PARTY_ID,

:old.CIS_SEC_PARTY_ID,

:old.EFCTV_START_DT,


:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_RLNSHP_H( CIS_PARTY_RLNSHP_H_ID,

CIS_PARTY_RLNSHP_ID,

CIS_PARTY_RLNSHP_TYPE_ID,

CIS_PRI_PARTY_ID,


CIS_SEC_PARTY_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_RLNSHP_H_S.nextval
,

:new.CIS_PARTY_RLNSHP_ID,

:new.CIS_PARTY_RLNSHP_TYPE_ID,

:new.CIS_PRI_PARTY_ID,

:new.CIS_SEC_PARTY_ID,

:new.EFCTV_START_DT,


:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PARTY_RLNSHP_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_RLNSHP FOR CIS.CIS_PARTY_RLNSHP;


ALTER TABLE CIS.CIS_PARTY_RLNSHP ADD (
  CONSTRAINT CIS_PARTYRELSHP_PK
  PRIMARY KEY
  (CIS_PARTY_RLNSHP_ID)
  USING INDEX CIS.CIS_PARTYRLNSHP_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTYRELSHP_UK
  UNIQUE (CIS_PARTY_RLNSHP_TYPE_ID, CIS_PRI_PARTY_ID, CIS_SEC_PARTY_ID, EFCTV_START_DT)
  USING INDEX CIS.CIS_PARTYRLNSHP_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PARTY_RLNSHP ADD (
  CONSTRAINT CIS_PARTY_PARTYRELSHPPRI_FK 
  FOREIGN KEY (CIS_PRI_PARTY_ID) 
  REFERENCES CIS.CIS_PARTY (CIS_PARTY_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTY_PARTYRELSHPSEC_FK 
  FOREIGN KEY (CIS_SEC_PARTY_ID) 
  REFERENCES CIS.CIS_PARTY (CIS_PARTY_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTY_RELATETYPE_RELSHP_FK 
  FOREIGN KEY (CIS_PARTY_RLNSHP_TYPE_ID) 
  REFERENCES CIS.CIS_PARTY_RLNSHP_TYPE (CIS_PARTY_RLNSHP_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_PARTYRLNSHP_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_RLNSHP TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_RLNSHP TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_INFO_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_INFO_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_INFO_H
(
  CIS_PARTY_INFO_H_ID       NUMBER(20)          NOT NULL,
  CIS_PARTY_INFO_ID         NUMBER(20)          NOT NULL,
  CIS_PARTY_ID              NUMBER(20)          NOT NULL,
  CIS_PARTY_SRC_ID_TYPE_ID  NUMBER(20)          NOT NULL,
  PARTY_SRC_ID              VARCHAR2(50 BYTE)   NOT NULL,
  EFCTV_START_DT            DATE                NOT NULL,
  EFCTV_END_DT              DATE,
  FIRST_NM                  VARCHAR2(50 BYTE),
  MIDDLE_NM                 VARCHAR2(50 BYTE),
  LAST_NM                   VARCHAR2(50 BYTE),
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  REC_CRTR_PARTY_ID         NUMBER(20)          NOT NULL,
  SRC_APLCTN_PARTY_ID       NUMBER(20)          NOT NULL,
  REC_MDFD_TYPE_CD          VARCHAR2(1 BYTE)    NOT NULL,
  REC_CRTD_DT               DATE                DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_INFO_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PARTY_INFO_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_INFO_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_PARTY_INFO_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_PARTY_INFO_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_PARTY_INFO_H_PK ON CIS.CIS_PARTY_INFO_H
(CIS_PARTY_INFO_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_INFO_H FOR CIS.CIS_PARTY_INFO_H;


ALTER TABLE CIS.CIS_PARTY_INFO_H ADD (
  CONSTRAINT CIS_PARTY_INFO_H_PK
  PRIMARY KEY
  (CIS_PARTY_INFO_H_ID)
  USING INDEX CIS.CIS_PARTY_INFO_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_INFO_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_INFO_H TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY_INFO
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY_INFO CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY_INFO
(
  CIS_PARTY_INFO_ID         NUMBER(20)          NOT NULL,
  CIS_PARTY_ID              NUMBER(20)          NOT NULL,
  CIS_PARTY_SRC_ID_TYPE_ID  NUMBER(20)          NOT NULL,
  PARTY_SRC_ID              VARCHAR2(50 BYTE)   NOT NULL,
  EFCTV_START_DT            DATE                NOT NULL,
  EFCTV_END_DT              DATE,
  FIRST_NM                  VARCHAR2(50 BYTE),
  MIDDLE_NM                 VARCHAR2(50 BYTE),
  LAST_NM                   VARCHAR2(50 BYTE),
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY_INFO.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_PARTYINFO_PK ON CIS.CIS_PARTY_INFO
(CIS_PARTY_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_PARTYINFO_UK ON CIS.CIS_PARTY_INFO
(CIS_PARTY_SRC_ID_TYPE_ID, CIS_PARTY_ID, EFCTV_START_DT)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTY_PARTYHISTORY_FK_I ON CIS.CIS_PARTY_INFO
(CIS_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PRTYSRCIDTY_PRTYINFO_FK_I ON CIS.CIS_PARTY_INFO
(CIS_PARTY_SRC_ID_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_PARTY_INFO_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_PARTY_INFO
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_INFO_H( CIS_PARTY_INFO_H_ID,

CIS_PARTY_INFO_ID,

CIS_PARTY_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID,


EFCTV_START_DT,

EFCTV_END_DT,

FIRST_NM,

MIDDLE_NM,

LAST_NM,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_INFO_H_S.nextval
,

:old.CIS_PARTY_INFO_ID,

:old.CIS_PARTY_ID,

:old.CIS_PARTY_SRC_ID_TYPE_ID,

:old.PARTY_SRC_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.FIRST_NM,

:old.MIDDLE_NM,

:old.LAST_NM,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_PARTY_INFO_H( CIS_PARTY_INFO_H_ID,

CIS_PARTY_INFO_ID,

CIS_PARTY_ID,

CIS_PARTY_SRC_ID_TYPE_ID,

PARTY_SRC_ID,


EFCTV_START_DT,

EFCTV_END_DT,

FIRST_NM,

MIDDLE_NM,

LAST_NM,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_PARTY_INFO_H_S.nextval
,

:new.CIS_PARTY_INFO_ID,

:new.CIS_PARTY_ID,

:new.CIS_PARTY_SRC_ID_TYPE_ID,

:new.PARTY_SRC_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.FIRST_NM,

:new.MIDDLE_NM,

:new.LAST_NM,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_PARTY_INFO_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY_INFO FOR CIS.CIS_PARTY_INFO;


ALTER TABLE CIS.CIS_PARTY_INFO ADD (
  CONSTRAINT CIS_PARTYINFO_PK
  PRIMARY KEY
  (CIS_PARTY_INFO_ID)
  USING INDEX CIS.CIS_PARTYINFO_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTYINFO_UK
  UNIQUE (CIS_PARTY_SRC_ID_TYPE_ID, CIS_PARTY_ID, EFCTV_START_DT)
  USING INDEX CIS.CIS_PARTYINFO_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PARTY_INFO ADD (
  CONSTRAINT CIS_PARTY_PARTYHISTORY_FK 
  FOREIGN KEY (CIS_PARTY_ID) 
  REFERENCES CIS.CIS_PARTY (CIS_PARTY_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRTYSRCIDTY_PRTYINFO_FK 
  FOREIGN KEY (CIS_PARTY_SRC_ID_TYPE_ID) 
  REFERENCES CIS.CIS_PARTY_SRC_ID_TYPE (CIS_PARTY_SRC_ID_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_PARTYINFO_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY_INFO TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY_INFO TO CIS_RW;
ALTER TABLE CIS.CIS_PARTY
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_PARTY CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_PARTY
(
  CIS_PARTY_ID       NUMBER(20)                 NOT NULL,
  EFCTV_START_DT     DATE                       NOT NULL,
  EFCTV_END_DT       DATE,
  REC_MDFD_CNT       NUMBER(18)                 NOT NULL,
  CIS_PROVENANCE_ID  NUMBER(20)
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_PARTY.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_PARTY.CIS_PROVENANCE_ID IS 'This is defined as Nullable as in some cases - party record will be created before provenance record is created.
For example, creating party record for the user who does not exist in the system yet. In such cases,
create party record, then provenance record and then update party record to have provenance_id';


CREATE UNIQUE INDEX CIS.CIS_PARTY_PK ON CIS.CIS_PARTY
(CIS_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_PARTY FOR CIS.CIS_PARTY;


ALTER TABLE CIS.CIS_PARTY ADD (
  CONSTRAINT CIS_PARTY_PK
  PRIMARY KEY
  (CIS_PARTY_ID)
  USING INDEX CIS.CIS_PARTY_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_PARTY ADD (
  CONSTRAINT CIS_PRVNC_PARTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_PARTY TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_PARTY TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_STATUS_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_STATUS_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_STATUS_TYPE_H
(
  CIS_INFLGHT_STATUS_TYPE_H_ID  NUMBER(20)      NOT NULL,
  CIS_INFLGHT_STATUS_TYPE_ID    NUMBER(20)      NOT NULL,
  INFLGHT_STATUS_TYPE_CD        VARCHAR2(5 BYTE) NOT NULL,
  INFLGHT_STATUS_TYPE_NM        VARCHAR2(30 BYTE) NOT NULL,
  INFLGHT_STATUS_TYPE_DESC_TX   VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT                  NUMBER(18)      NOT NULL,
  REC_CRTR_PARTY_ID             NUMBER(20)      NOT NULL,
  SRC_APLCTN_PARTY_ID           NUMBER(20)      NOT NULL,
  REC_MDFD_TYPE_CD              VARCHAR2(1 BYTE) NOT NULL,
  REC_CRTD_DT                   DATE            DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID             NUMBER(20)      NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_INFLGHT_STATUS_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_INFLGHT_STATUS_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_STATUS_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_STATUS_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_INFLGHT_STATUS_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_INFLGHT_STATUS_TYPE_H_PK ON CIS.CIS_INFLGHT_STATUS_TYPE_H
(CIS_INFLGHT_STATUS_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_STATUS_TYPE_H FOR CIS.CIS_INFLGHT_STATUS_TYPE_H;


ALTER TABLE CIS.CIS_INFLGHT_STATUS_TYPE_H ADD (
  CONSTRAINT CIS_INFLGHT_STATUS_TYPE_H_PK
  PRIMARY KEY
  (CIS_INFLGHT_STATUS_TYPE_H_ID)
  USING INDEX CIS.CIS_INFLGHT_STATUS_TYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_STATUS_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_STATUS_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_STATUS_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_STATUS_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_STATUS_TYPE
(
  CIS_INFLGHT_STATUS_TYPE_ID   NUMBER(20)       NOT NULL,
  INFLGHT_STATUS_TYPE_CD       VARCHAR2(5 BYTE) NOT NULL,
  INFLGHT_STATUS_TYPE_NM       VARCHAR2(30 BYTE) NOT NULL,
  INFLGHT_STATUS_TYPE_DESC_TX  VARCHAR2(100 BYTE) NOT NULL,
  REC_MDFD_CNT                 NUMBER(18)       NOT NULL,
  CIS_PROVENANCE_ID            NUMBER(20)       NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_INFLGHT_STATUS_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_INFLGHT_STATUS_TYPE_PK ON CIS.CIS_INFLGHT_STATUS_TYPE
(CIS_INFLGHT_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_INFLGHT_STATUS_TYPE_UK_I ON CIS.CIS_INFLGHT_STATUS_TYPE
(INFLGHT_STATUS_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_STATUS__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_STATUS_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_STATUS_TYPE_H( CIS_INFLGHT_STATUS_TYPE_H_ID,

CIS_INFLGHT_STATUS_TYPE_ID,

INFLGHT_STATUS_TYPE_CD,


INFLGHT_STATUS_TYPE_NM,

INFLGHT_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_STATUS_TYPE_H_S.nextval
,

:old.CIS_INFLGHT_STATUS_TYPE_ID,

:old.INFLGHT_STATUS_TYPE_CD,

:old.INFLGHT_STATUS_TYPE_NM,

:old.INFLGHT_STATUS_TYPE_DESC_TX,


:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_STATUS_TYPE_H( CIS_INFLGHT_STATUS_TYPE_H_ID,

CIS_INFLGHT_STATUS_TYPE_ID,

INFLGHT_STATUS_TYPE_CD,


INFLGHT_STATUS_TYPE_NM,

INFLGHT_STATUS_TYPE_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_STATUS_TYPE_H_S.nextval
,

:new.CIS_INFLGHT_STATUS_TYPE_ID,

:new.INFLGHT_STATUS_TYPE_CD,

:new.INFLGHT_STATUS_TYPE_NM,

:new.INFLGHT_STATUS_TYPE_DESC_TX,


:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_INFLGHT_STATUS__AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_STATUS_TYPE FOR CIS.CIS_INFLGHT_STATUS_TYPE;


ALTER TABLE CIS.CIS_INFLGHT_STATUS_TYPE ADD (
  CONSTRAINT CIS_INFLGHT_STATUS_TYPE_PK
  PRIMARY KEY
  (CIS_INFLGHT_STATUS_TYPE_ID)
  USING INDEX CIS.CIS_INFLGHT_STATUS_TYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_INFLGHT_STATUS_TYPE_UK
  UNIQUE (INFLGHT_STATUS_TYPE_CD)
  USING INDEX CIS.CIS_INFLGHT_STATUS_TYPE_UK_I
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_INFLGHT_STATUS_TYPE ADD (
  CONSTRAINT CIS_PRVNC_INFLGHTSTTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_STATUS_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_STATUS_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_DATA_STATUS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_DATA_STATUS_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_DATA_STATUS_H
(
  CIS_INFLGHT_DATA_STATUS_H_ID  NUMBER(20)      NOT NULL,
  CIS_INFLGHT_DATA_STATUS_ID    NUMBER(20)      NOT NULL,
  CIS_INFLGHT_STATUS_TYPE_ID    NUMBER(20)      NOT NULL,
  EFCTV_START_DT                DATE            NOT NULL,
  EFCTV_END_DT                  DATE,
  REC_MDFD_CNT                  NUMBER(18)      NOT NULL,
  REC_CRTR_PARTY_ID             NUMBER(20)      NOT NULL,
  SRC_APLCTN_PARTY_ID           NUMBER(20)      NOT NULL,
  REC_MDFD_TYPE_CD              VARCHAR2(1 BYTE) NOT NULL,
  REC_CRTD_DT                   DATE            DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID             NUMBER(20)      NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.CIS_INFLGHT_DATA_STATUS_H_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.EFCTV_START_DT IS 'Effective date of the status';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.EFCTV_END_DT IS 'End Date of the status. For a CIS_IN_FLGHT_DATA_ID, there should be only one status row with NULL END_DT, which represents the current status.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_STATUS_H_PK ON CIS.CIS_INFLGHT_DATA_STATUS_H
(CIS_INFLGHT_DATA_STATUS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_DATA_STATUS_H FOR CIS.CIS_INFLGHT_DATA_STATUS_H;


ALTER TABLE CIS.CIS_INFLGHT_DATA_STATUS_H ADD (
  CONSTRAINT CIS_INFLGHT_DATA_STATUS_H_PK
  PRIMARY KEY
  (CIS_INFLGHT_DATA_STATUS_H_ID)
  USING INDEX CIS.CIS_INFLGHT_DATA_STATUS_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_DATA_STATUS_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_STATUS_H TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_DATA_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_DATA_STATUS CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_DATA_STATUS
(
  CIS_INFLGHT_DATA_STATUS_ID  NUMBER(20)        NOT NULL,
  CIS_INFLGHT_STATUS_TYPE_ID  NUMBER(20)        NOT NULL,
  EFCTV_START_DT              DATE              NOT NULL,
  EFCTV_END_DT                DATE,
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS.CIS_INFLGHT_DATA_STATUS_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS.EFCTV_START_DT IS 'Effective date of the status';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS.EFCTV_END_DT IS 'End Date of the status. For a CIS_IN_FLGHT_DATA_ID, there should be only one status row with NULL END_DT, which represents the current status.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_STATUS.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_STATUS_PK ON CIS.CIS_INFLGHT_DATA_STATUS
(CIS_INFLGHT_DATA_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_INFLGHT_STTS_TY_DATA_FK_I ON CIS.CIS_INFLGHT_DATA_STATUS
(CIS_INFLGHT_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_DATA_ST_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_DATA_STATUS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_DATA_STATUS_H( CIS_INFLGHT_DATA_STATUS_H_ID,

CIS_INFLGHT_DATA_STATUS_ID,

CIS_INFLGHT_STATUS_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_STATUS_H_S.nextval
,

:old.CIS_INFLGHT_DATA_STATUS_ID,

:old.CIS_INFLGHT_STATUS_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,


:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_DATA_STATUS_H( CIS_INFLGHT_DATA_STATUS_H_ID,

CIS_INFLGHT_DATA_STATUS_ID,

CIS_INFLGHT_STATUS_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_STATUS_H_S.nextval
,

:new.CIS_INFLGHT_DATA_STATUS_ID,

:new.CIS_INFLGHT_STATUS_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,


:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_INFLGHT_DATA_ST_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_DATA_STATUS FOR CIS.CIS_INFLGHT_DATA_STATUS;


ALTER TABLE CIS.CIS_INFLGHT_DATA_STATUS ADD (
  CONSTRAINT CIS_INFLGHT_DATA_STATUS_PK
  PRIMARY KEY
  (CIS_INFLGHT_DATA_STATUS_ID)
  USING INDEX CIS.CIS_INFLGHT_DATA_STATUS_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_INFLGHT_DATA_STATUS ADD (
  CONSTRAINT CIS_INFLGHT_STTS_TY_DATA_FK 
  FOREIGN KEY (CIS_INFLGHT_STATUS_TYPE_ID) 
  REFERENCES CIS.CIS_INFLGHT_STATUS_TYPE (CIS_INFLGHT_STATUS_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_INFLGHTDTST_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_DATA_STATUS TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_STATUS TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_DATA_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_DATA_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_DATA_H
(
  CIS_INFLGHT_DATA_H_ID       NUMBER(20)        NOT NULL,
  CIS_INFLGHT_DATA_ID         NUMBER(20)        NOT NULL,
  CIS_INFLGHT_DATA_STATUS_ID  NUMBER(20)        NOT NULL,
  ICN                         VARCHAR2(50 BYTE) NOT NULL,
  TRANSACTION_ID_TX           VARCHAR2(100 BYTE) NOT NULL,
  TRANSACTION_DATE            DATE              NOT NULL,
  VLDTN_OVERRIDE_FLG          VARCHAR2(1 BYTE)  DEFAULT 'N',
  VLDTN_PROOF                 VARCHAR2(100 BYTE),
  FAULT_TO                    VARCHAR2(100 BYTE),
  REPLY_TO                    VARCHAR2(100 BYTE),
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  REC_CRTR_PARTY_ID           NUMBER(20)        NOT NULL,
  SRC_APLCTN_PARTY_ID         NUMBER(20)        NOT NULL,
  REC_MDFD_TYPE_CD            VARCHAR2(1 BYTE)  NOT NULL,
  REC_CRTD_DT                 DATE              DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_INFLGHT_DATA_H IS 'When a eCIS service request is made by a consumer to create/update a contact information, data received in the service request are stored into this table along with transaction_id. These data goes thru various steps based on the business rules, which is identified by data_status_id.  Data in table is not considered an active contact info until it passes all business validation rules.
Once request data passes all business rules, data is transferred to "contact info" as  valid data - available to all consumers as current contact info.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.CIS_INFLGHT_DATA_H_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.TRANSACTION_ID_TX IS 'Transaction ID supplied in Service Request';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.VLDTN_OVERRIDE_FLG IS 'Override Address Flag is used to override address validation and use the address as supplied. Valid values are Y or N';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.FAULT_TO IS 'This is part of WS-Messaging,  it can be URL where the fault message is sent.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.REPLY_TO IS 'This is part of WS-Messaging,  it can be URL where the reply message is sent.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE INDEX CIS.CIS_INFLGHT_DATA_H_PK ON CIS.CIS_INFLGHT_DATA_H
(CIS_INFLGHT_DATA_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_DATA_H FOR CIS.CIS_INFLGHT_DATA_H;


ALTER TABLE CIS.CIS_INFLGHT_DATA_H ADD (
  CONSTRAINT CIS_INFLGHT_DATA_H_PK
  PRIMARY KEY
  (CIS_INFLGHT_DATA_H_ID)
  USING INDEX CIS.CIS_INFLGHT_DATA_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_DATA_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_H TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_DATA_CLOB_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_DATA_CLOB_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_DATA_CLOB_H
(
  CIS_INFLGHT_DATA_H_ID  NUMBER(20)             NOT NULL,
  CIS_INFLGHT_DATA_ID    NUMBER(20)             NOT NULL,
  REQUEST_DATA           CLOB                   NOT NULL,
  REC_CRTR_PARTY_ID      NUMBER(20)             NOT NULL,
  SRC_APLCTN_PARTY_ID    NUMBER(20)             NOT NULL,
  REC_MDFD_TYPE_CD       VARCHAR2(1 BYTE)       NOT NULL,
  REC_CRTD_DT            DATE                   DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
LOB (REQUEST_DATA) STORE AS (
  TABLESPACE  L_CIS_LOB_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_INFLGHT_DATA_CLOB_H IS 'This table holds the CLOB data for CIS_INFLGHT_DATA table. This CLOB holds the whole XML file came in from a consumer as a request to insert/update contact info';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_CLOB_H.REQUEST_DATA IS 'XML Data came in with service request';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_CLOB_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_CLOB_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_CLOB_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_CLOB_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_CLOB_H_PK ON CIS.CIS_INFLGHT_DATA_CLOB_H
(CIS_INFLGHT_DATA_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_DATA_CLOB_H FOR CIS.CIS_INFLGHT_DATA_CLOB_H;


ALTER TABLE CIS.CIS_INFLGHT_DATA_CLOB_H ADD (
  CONSTRAINT CIS_INFLGHT_DATA_CLOB_H_PK
  PRIMARY KEY
  (CIS_INFLGHT_DATA_H_ID)
  USING INDEX CIS.CIS_INFLGHT_DATA_CLOB_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_DATA_CLOB_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_CLOB_H TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_DATA_CLOB
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_DATA_CLOB CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_DATA_CLOB
(
  CIS_INFLGHT_DATA_ID  NUMBER(20)               NOT NULL,
  REQUEST_DATA         CLOB                     NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
LOB (REQUEST_DATA) STORE AS (
  TABLESPACE  L_CIS_LOB_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_INFLGHT_DATA_CLOB IS 'This table holds the CLOB data for CIS_INFLGHT_DATA table. This CLOB holds the whole XML file came in from a consumer as a request to insert/update contact info';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA_CLOB.REQUEST_DATA IS 'XML Data came in with service request';


CREATE UNIQUE INDEX CIS.CIS_INFLGHT_DATA_CLOB_PFK ON CIS.CIS_INFLGHT_DATA_CLOB
(CIS_INFLGHT_DATA_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_DATA_CL_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_DATA_CLOB
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_DATA_CLOB_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

REQUEST_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_CLOB_H_S.nextval
,

:old.CIS_INFLGHT_DATA_ID,

:old.REQUEST_DATA,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,
'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_DATA_CLOB_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

REQUEST_DATA,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_INFLGHT_DATA_CLOB_H_S.nextval
,

:new.CIS_INFLGHT_DATA_ID,

:new.REQUEST_DATA,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,
mDML);
end if;
end CIS_INFLGHT_DATA_CL_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_DATA_CLOB FOR CIS.CIS_INFLGHT_DATA_CLOB;


ALTER TABLE CIS.CIS_INFLGHT_DATA_CLOB ADD (
  CONSTRAINT CIS_INFLGHT_DATA_CLOB_PFK
  PRIMARY KEY
  (CIS_INFLGHT_DATA_ID)
  USING INDEX CIS.CIS_INFLGHT_DATA_CLOB_PFK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_INFLGHT_DATA_CLOB ADD (
  CONSTRAINT CIS_INFLGHT_DATA_CLOB_FK 
  FOREIGN KEY (CIS_INFLGHT_DATA_ID) 
  REFERENCES CIS.CIS_INFLGHT_DATA (CIS_INFLGHT_DATA_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_INFLGHTDATACLOB_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_DATA_CLOB TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA_CLOB TO CIS_RW;
ALTER TABLE CIS.CIS_INFLGHT_DATA
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_INFLGHT_DATA CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_INFLGHT_DATA
(
  CIS_INFLGHT_DATA_ID         NUMBER(20)        NOT NULL,
  CIS_INFLGHT_DATA_STATUS_ID  NUMBER(20)        NOT NULL,
  ICN                         VARCHAR2(50 BYTE) NOT NULL,
  TRANSACTION_ID_TX           VARCHAR2(100 BYTE) NOT NULL,
  TRANSACTION_DATE            DATE              NOT NULL,
  VLDTN_OVERRIDE_FLG          VARCHAR2(1 BYTE)  DEFAULT 'N',
  VLDTN_PROOF                 VARCHAR2(100 BYTE),
  FAULT_TO                    VARCHAR2(100 BYTE),
  REPLY_TO                    VARCHAR2(100 BYTE),
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_INFLGHT_DATA IS 'When a eCIS service request is made by a consumer to create/update a contact information, data received in the service request are stored into this table along with transaction_id. These data goes thru various steps based on the business rules, which is identified by data_status_id.  Data in table is not considered an active contact info until it passes all business validation rules.
Once request data passes all business rules, data is transferred to "contact info" as  valid data - available to all consumers as current contact info.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA.CIS_INFLGHT_DATA_ID IS 'Surrogate Key';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA.TRANSACTION_ID_TX IS 'Transaction ID supplied in Service Request';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA.VLDTN_OVERRIDE_FLG IS 'Override Address Flag is used to override address validation and use the address as supplied. Valid values are Y or N';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA.FAULT_TO IS 'This is part of WS-Messaging,  it can be URL where the fault message is sent.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA.REPLY_TO IS 'This is part of WS-Messaging,  it can be URL where the reply message is sent.';

COMMENT ON COLUMN CIS.CIS_INFLGHT_DATA.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE INDEX CIS.CIS_INFLGHT_DATA_PK ON CIS.CIS_INFLGHT_DATA
(CIS_INFLGHT_DATA_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_INFLGHT_STATUS_DATA_FK_I ON CIS.CIS_INFLGHT_DATA
(CIS_INFLGHT_DATA_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_INFLGHT_DATA_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_INFLGHT_DATA
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_DATA_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

CIS_INFLGHT_DATA_STATUS_ID,

ICN,


TRANSACTION_ID_TX,

TRANSACTION_DATE,

VLDTN_OVERRIDE_FLG,

VLDTN_PROOF,

FAULT_TO,

REPLY_TO,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_INFLGHT_DATA_H_S.nextval
,

:old.CIS_INFLGHT_DATA_ID,

:old.CIS_INFLGHT_DATA_STATUS_ID,

:old.ICN,

:old.TRANSACTION_ID_TX,

:old.TRANSACTION_DATE,

:old.VLDTN_OVERRIDE_FLG,

:old.VLDTN_PROOF,

:old.FAULT_TO,

:old.REPLY_TO,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_INFLGHT_DATA_H( CIS_INFLGHT_DATA_H_ID,

CIS_INFLGHT_DATA_ID,

CIS_INFLGHT_DATA_STATUS_ID,

ICN,


TRANSACTION_ID_TX,

TRANSACTION_DATE,

VLDTN_OVERRIDE_FLG,

VLDTN_PROOF,

FAULT_TO,

REPLY_TO,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_INFLGHT_DATA_H_S.nextval
,

:new.CIS_INFLGHT_DATA_ID,

:new.CIS_INFLGHT_DATA_STATUS_ID,

:new.ICN,

:new.TRANSACTION_ID_TX,

:new.TRANSACTION_DATE,

:new.VLDTN_OVERRIDE_FLG,

:new.VLDTN_PROOF,

:new.FAULT_TO,

:new.REPLY_TO,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_INFLGHT_DATA_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_INFLGHT_DATA FOR CIS.CIS_INFLGHT_DATA;


ALTER TABLE CIS.CIS_INFLGHT_DATA ADD (
  CONSTRAINT CIS_VLDTN_OVERRIDE_FLG_CHK
  CHECK (VLDTN_OVERRIDE_FLG IN ('Y','N'))
  ENABLE VALIDATE,
  CONSTRAINT CIS_INFLGHT_DATA_PK
  PRIMARY KEY
  (CIS_INFLGHT_DATA_ID)
  USING INDEX CIS.CIS_INFLGHT_DATA_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_INFLGHT_DATA ADD (
  CONSTRAINT CIS_INFLGHT_STATUS_DATA_FK 
  FOREIGN KEY (CIS_INFLGHT_DATA_STATUS_ID) 
  REFERENCES CIS.CIS_INFLGHT_DATA_STATUS (CIS_INFLGHT_DATA_STATUS_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_INFLGHT_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_INFLGHT_DATA TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_INFLGHT_DATA TO CIS_RW;
ALTER TABLE CIS.CIS_EMAIL_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_EMAIL_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_EMAIL_TYPE_H
(
  CIS_EMAIL_TYPE_H_ID  NUMBER(20)               NOT NULL,
  EMAIL_TYPE_CD        VARCHAR2(5 BYTE)         NOT NULL,
  CIS_EMAIL_TYPE_ID    NUMBER(20)               NOT NULL,
  EMAIL_TYPE_NM        VARCHAR2(30 BYTE)        NOT NULL,
  EMAIL_TYPE_DESC_TX   VARCHAR2(100 BYTE)       NOT NULL,
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  REC_CRTR_PARTY_ID    NUMBER(20)               NOT NULL,
  SRC_APLCTN_PARTY_ID  NUMBER(20)               NOT NULL,
  REC_MDFD_TYPE_CD     VARCHAR2(1 BYTE)         NOT NULL,
  REC_CRTD_DT          DATE                     DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_EMAIL_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_EMAIL_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_EMAIL_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_EMAIL_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_EMAIL_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_EMAILTYPE_H_PK ON CIS.CIS_EMAIL_TYPE_H
(CIS_EMAIL_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_EMAIL_TYPE_H FOR CIS.CIS_EMAIL_TYPE_H;


ALTER TABLE CIS.CIS_EMAIL_TYPE_H ADD (
  CONSTRAINT CIS_EMAILTYPE_H_PK
  PRIMARY KEY
  (CIS_EMAIL_TYPE_H_ID)
  USING INDEX CIS.CIS_EMAILTYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_EMAIL_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_EMAIL_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_EMAIL_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_EMAIL_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_EMAIL_TYPE
(
  CIS_EMAIL_TYPE_ID   NUMBER(20)                NOT NULL,
  EMAIL_TYPE_CD       VARCHAR2(5 BYTE)          NOT NULL,
  EMAIL_TYPE_NM       VARCHAR2(30 BYTE)         NOT NULL,
  EMAIL_TYPE_DESC_TX  VARCHAR2(100 BYTE)        NOT NULL,
  REC_MDFD_CNT        NUMBER(18)                NOT NULL,
  CIS_PROVENANCE_ID   NUMBER(20)                NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_EMAIL_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_EMAILTYPE_CD_UK ON CIS.CIS_EMAIL_TYPE
(EMAIL_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_EMAILTYPE_PK ON CIS.CIS_EMAIL_TYPE
(CIS_EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_EMAIL_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_EMAIL_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_EMAIL_TYPE_H( CIS_EMAIL_TYPE_H_ID,

CIS_EMAIL_TYPE_ID,

EMAIL_TYPE_CD,

EMAIL_TYPE_NM,

EMAIL_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_EMAIL_TYPE_H_S.nextval
,

:old.CIS_EMAIL_TYPE_ID,

:old.EMAIL_TYPE_CD,

:old.EMAIL_TYPE_NM,

:old.EMAIL_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_EMAIL_TYPE_H( CIS_EMAIL_TYPE_H_ID,

CIS_EMAIL_TYPE_ID,

EMAIL_TYPE_CD,

EMAIL_TYPE_NM,

EMAIL_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_EMAIL_TYPE_H_S.nextval
,

:new.CIS_EMAIL_TYPE_ID,

:new.EMAIL_TYPE_CD,

:new.EMAIL_TYPE_NM,

:new.EMAIL_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_EMAIL_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_EMAIL_TYPE FOR CIS.CIS_EMAIL_TYPE;


ALTER TABLE CIS.CIS_EMAIL_TYPE ADD (
  CONSTRAINT CIS_EMAILTYPE_PK
  PRIMARY KEY
  (CIS_EMAIL_TYPE_ID)
  USING INDEX CIS.CIS_EMAILTYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_EMAILTYPE_CD_UK
  UNIQUE (EMAIL_TYPE_CD)
  USING INDEX CIS.CIS_EMAILTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_EMAIL_TYPE ADD (
  CONSTRAINT CIS_PRVNC_CONTINFOEMAILTY_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_EMAIL_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_EMAIL_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_TYPE_PRPS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_TYPE_PRPS_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_TYPE_PRPS_H
(
  CIS_CONT_INFO_TYPE_PRPS_H_ID  NUMBER(20)      NOT NULL,
  CIS_CONT_INFO_TYPE_PRPS_ID    NUMBER(20)      NOT NULL,
  CIS_PURP_TYPE_ID              NUMBER(20)      NOT NULL,
  CIS_CONT_INFO_TYPE_ID         NUMBER(20)      NOT NULL,
  REC_MDFD_CNT                  NUMBER(18)      NOT NULL,
  REC_CRTR_PARTY_ID             NUMBER(20)      NOT NULL,
  SRC_APLCTN_PARTY_ID           NUMBER(20)      NOT NULL,
  REC_MDFD_TYPE_CD              VARCHAR2(1 BYTE) NOT NULL,
  REC_CRTD_DT                   DATE            DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID             NUMBER(20)      NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_CONT_INFO_TYPE_PRPS_H IS 'This table establishes relationship between contact info type and purpose of use type.
For example, Purpose Of Use Type, "TTY", this is only valid for Phone, so it creates relationship With Phone.

Each POU type will have at least one entry in this table.';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_PRPS_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_PRPS_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_PRPS_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_PRPS_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_PRPS_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_H_PK ON CIS.CIS_CONT_INFO_TYPE_PRPS_H
(CIS_CONT_INFO_TYPE_PRPS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_TYPE_PRPS_H FOR CIS.CIS_CONT_INFO_TYPE_PRPS_H;


ALTER TABLE CIS.CIS_CONT_INFO_TYPE_PRPS_H ADD (
  CONSTRAINT CIS_CONT_INFO_TYPE_PRPS_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_TYPE_PRPS_H_ID)
  USING INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_PRPS_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE_PRPS_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_TYPE_PRPS
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_TYPE_PRPS CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_TYPE_PRPS
(
  CIS_CONT_INFO_TYPE_PRPS_ID  NUMBER(20)        NOT NULL,
  CIS_PURP_TYPE_ID            NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_TYPE_ID       NUMBER(20)        NOT NULL,
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE CIS.CIS_CONT_INFO_TYPE_PRPS IS 'This table establishes relationship between contact info type and purpose of use type.
For example, Purpose Of Use Type, TTY -  this is only valid for Phone, so it creates relationship With Phone.
Each POU type will have at least one entry in this table.';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_PRPS.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_PK ON CIS.CIS_CONT_INFO_TYPE_PRPS
(CIS_CONT_INFO_TYPE_PRPS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CT_TYPE_TYPEPRPS_FK_I ON CIS.CIS_CONT_INFO_TYPE_PRPS
(CIS_CONT_INFO_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PRPS_TYPE_PRPS_FK_I ON CIS.CIS_CONT_INFO_TYPE_PRPS
(CIS_PURP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_TYPE__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_TYPE_PRPS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_TYPE_PRPS_H( CIS_CONT_INFO_TYPE_PRPS_H_ID,

CIS_CONT_INFO_TYPE_PRPS_ID,

CIS_PURP_TYPE_ID,


CIS_CONT_INFO_TYPE_ID,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_PRPS_H_S.nextval
,

:old.CIS_CONT_INFO_TYPE_PRPS_ID,

:old.CIS_PURP_TYPE_ID,

:old.CIS_CONT_INFO_TYPE_ID,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID
,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_TYPE_PRPS_H( CIS_CONT_INFO_TYPE_PRPS_H_ID,

CIS_CONT_INFO_TYPE_PRPS_ID,

CIS_PURP_TYPE_ID,


CIS_CONT_INFO_TYPE_ID,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_PRPS_H_S.nextval
,

:new.CIS_CONT_INFO_TYPE_PRPS_ID,

:new.CIS_PURP_TYPE_ID,

:new.CIS_CONT_INFO_TYPE_ID,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID
,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_TYPE__AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_TYPE_PRPS FOR CIS.CIS_CONT_INFO_TYPE_PRPS;


ALTER TABLE CIS.CIS_CONT_INFO_TYPE_PRPS ADD (
  CONSTRAINT CIS_CONT_INFO_TYPE_PRPS_PK
  PRIMARY KEY
  (CIS_CONT_INFO_TYPE_PRPS_ID)
  USING INDEX CIS.CIS_CONT_INFO_TYPE_PRPS_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_TYPE_PRPS ADD (
  CONSTRAINT CIS_CI_TYPE_TYPEPRPS_FK 
  FOREIGN KEY (CIS_CONT_INFO_TYPE_ID) 
  REFERENCES CIS.CIS_CONT_INFO_TYPE (CIS_CONT_INFO_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRPS_TYPE_PRPS_FK 
  FOREIGN KEY (CIS_PURP_TYPE_ID) 
  REFERENCES CIS.CIS_PURPOSE_TYPE (CIS_PURP_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_TYPE_PRPS_RLN_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_PRPS TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE_PRPS TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_TYPE_H
(
  CIS_CONT_INFO_TYPE_H_ID  NUMBER(20)           NOT NULL,
  CIS_CONT_INFO_TYPE_ID    NUMBER(20)           NOT NULL,
  CONT_INFO_TYPE_CD        VARCHAR2(5 BYTE)     NOT NULL,
  CONT_INFO_TYPE_NM        VARCHAR2(30 BYTE)    NOT NULL,
  CONT_INFO_DESC_TX        VARCHAR2(100 BYTE)   NOT NULL,
  REC_MDFD_CNT             NUMBER(18)           NOT NULL,
  REC_CRTR_PARTY_ID        NUMBER(20)           NOT NULL,
  SRC_APLCTN_PARTY_ID      NUMBER(20)           NOT NULL,
  REC_MDFD_TYPE_CD         VARCHAR2(1 BYTE)     NOT NULL,
  REC_CRTD_DT              DATE                 DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID        NUMBER(20)           NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOTYPE_H_PK ON CIS.CIS_CONT_INFO_TYPE_H
(CIS_CONT_INFO_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_TYPE_H FOR CIS.CIS_CONT_INFO_TYPE_H;


ALTER TABLE CIS.CIS_CONT_INFO_TYPE_H ADD (
  CONSTRAINT CIS_CONTINFOTYPE_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_TYPE_H_ID)
  USING INDEX CIS.CIS_CONTINFOTYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_TYPE
(
  CIS_CONT_INFO_TYPE_ID  NUMBER(20)             NOT NULL,
  CONT_INFO_TYPE_CD      VARCHAR2(5 BYTE)       NOT NULL,
  CONT_INFO_TYPE_NM      VARCHAR2(30 BYTE)      NOT NULL,
  CONT_INFO_DESC_TX      VARCHAR2(100 BYTE)     NOT NULL,
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOTYPEID_PK ON CIS.CIS_CONT_INFO_TYPE
(CIS_CONT_INFO_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOTYPE_CD_UK ON CIS.CIS_CONT_INFO_TYPE
(CONT_INFO_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_TYPE_H( CIS_CONT_INFO_TYPE_H_ID,

CIS_CONT_INFO_TYPE_ID,

CONT_INFO_TYPE_CD,

CONT_INFO_TYPE_NM,


CONT_INFO_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_H_S.nextval
,

:old.CIS_CONT_INFO_TYPE_ID,

:old.CONT_INFO_TYPE_CD,

:old.CONT_INFO_TYPE_NM,

:old.CONT_INFO_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_TYPE_H( CIS_CONT_INFO_TYPE_H_ID,

CIS_CONT_INFO_TYPE_ID,

CONT_INFO_TYPE_CD,

CONT_INFO_TYPE_NM,


CONT_INFO_DESC_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_TYPE_H_S.nextval
,

:new.CIS_CONT_INFO_TYPE_ID,

:new.CONT_INFO_TYPE_CD,

:new.CONT_INFO_TYPE_NM,

:new.CONT_INFO_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_TYPE FOR CIS.CIS_CONT_INFO_TYPE;


ALTER TABLE CIS.CIS_CONT_INFO_TYPE ADD (
  CONSTRAINT CIS_CONTINFOTYPEID_PK
  PRIMARY KEY
  (CIS_CONT_INFO_TYPE_ID)
  USING INDEX CIS.CIS_CONTINFOTYPEID_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_CONTINFOTYPE_CD_UK
  UNIQUE (CONT_INFO_TYPE_CD)
  USING INDEX CIS.CIS_CONTINFOTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_TYPE ADD (
  CONSTRAINT CIS_PRVNC_CONTINFOTYP_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_TYPE TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_STATUS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_STATUS_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_STATUS_H
(
  CIS_CONT_INFO_STATUS_H_ID   NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_STATUS_ID     NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_DATA_QUAL_ID  NUMBER(20)        NOT NULL,
  CIS_EXT_STAT_TYPE_ID        NUMBER(20)        NOT NULL,
  CIS_INT_STAT_TYPE_ID        NUMBER(20)        NOT NULL,
  EFCTV_START_DT              DATE              NOT NULL,
  EFCTV_END_DT                DATE,
  COMNT_TX                    VARCHAR2(300 BYTE),
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  REC_CRTR_PARTY_ID           NUMBER(20)        NOT NULL,
  SRC_APLCTN_PARTY_ID         NUMBER(20)        NOT NULL,
  REC_MDFD_TYPE_CD            VARCHAR2(1 BYTE)  NOT NULL,
  REC_CRTD_DT                 DATE              DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_STATUS_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_STATUS_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_STATUS_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_STATUS_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_STATUS_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOSTATUS_H_PK ON CIS.CIS_CONT_INFO_STATUS_H
(CIS_CONT_INFO_STATUS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_STATUS_H FOR CIS.CIS_CONT_INFO_STATUS_H;


ALTER TABLE CIS.CIS_CONT_INFO_STATUS_H ADD (
  CONSTRAINT CIS_CONTINFOSTATUS_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_STATUS_H_ID)
  USING INDEX CIS.CIS_CONTINFOSTATUS_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_STATUS_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_STATUS_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_STATUS CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_STATUS
(
  CIS_CONT_INFO_STATUS_ID     NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_DATA_QUAL_ID  NUMBER(20)        NOT NULL,
  CIS_EXT_STAT_TYPE_ID        NUMBER(20)        NOT NULL,
  CIS_INT_STAT_TYPE_ID        NUMBER(20)        NOT NULL,
  EFCTV_START_DT              DATE              NOT NULL,
  EFCTV_END_DT                DATE,
  COMNT_TX                    VARCHAR2(300 BYTE),
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_STATUS.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE INDEX CIS.CIS_CONINFDATQUAL_INFSTAT_FK_I ON CIS.CIS_CONT_INFO_STATUS
(CIS_CONT_INFO_DATA_QUAL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOSTATUS_PK ON CIS.CIS_CONT_INFO_STATUS
(CIS_CONT_INFO_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_STATTYPE_CISEXTSTAT_FK_I ON CIS.CIS_CONT_INFO_STATUS
(CIS_EXT_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_STATTYPE_CISINTSTAT_FK_I ON CIS.CIS_CONT_INFO_STATUS
(CIS_INT_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_STATU_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_STATUS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_STATUS_H( CIS_CONT_INFO_STATUS_H_ID,

CIS_CONT_INFO_STATUS_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CIS_EXT_STAT_TYPE_ID,

CIS_INT_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

COMNT_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_STATUS_H_S.nextval
,

:old.CIS_CONT_INFO_STATUS_ID,

:old.CIS_CONT_INFO_DATA_QUAL_ID,

:old.CIS_EXT_STAT_TYPE_ID,

:old.CIS_INT_STAT_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.COMNT_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_STATUS_H( CIS_CONT_INFO_STATUS_H_ID,

CIS_CONT_INFO_STATUS_ID,

CIS_CONT_INFO_DATA_QUAL_ID,


CIS_EXT_STAT_TYPE_ID,

CIS_INT_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

COMNT_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_STATUS_H_S.nextval
,

:new.CIS_CONT_INFO_STATUS_ID,

:new.CIS_CONT_INFO_DATA_QUAL_ID,

:new.CIS_EXT_STAT_TYPE_ID,

:new.CIS_INT_STAT_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.COMNT_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_STATU_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_STATUS FOR CIS.CIS_CONT_INFO_STATUS;


ALTER TABLE CIS.CIS_CONT_INFO_STATUS ADD (
  CONSTRAINT CIS_CONTINFOSTATUS_PK
  PRIMARY KEY
  (CIS_CONT_INFO_STATUS_ID)
  USING INDEX CIS.CIS_CONTINFOSTATUS_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_STATUS ADD (
  CONSTRAINT CIS_CONINFDATQUAL_INFSTAT_FK 
  FOREIGN KEY (CIS_CONT_INFO_DATA_QUAL_ID) 
  REFERENCES CIS.CIS_CONT_INFO_DATA_QUALITY (CIS_CONT_INFO_DATA_QUAL_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOSTTS_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_STATTYPE_CISEXTSTAT_FK 
  FOREIGN KEY (CIS_EXT_STAT_TYPE_ID) 
  REFERENCES CIS.CIS_STAT_TYPE (CIS_STAT_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_STATTYPE_CISINTSTAT_FK 
  FOREIGN KEY (CIS_INT_STAT_TYPE_ID) 
  REFERENCES CIS.CIS_STAT_TYPE (CIS_STAT_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_STATUS TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_STATUS TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_RULE_STATUS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_RULE_STATUS_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_RULE_STATUS_H
(
  CIS_CONT_INFO_RULE_STATUS_H_ID  NUMBER(20)    NOT NULL,
  CIS_CONT_INFO_RULE_STATUS_ID    NUMBER(20)    NOT NULL,
  CIS_CONT_INFO_STATUS_ID         NUMBER(20)    NOT NULL,
  CIS_RULE_TYPE_ID                NUMBER(20)    NOT NULL,
  CIS_STAT_TYPE_ID                NUMBER(20)    NOT NULL,
  EFCTV_START_DT                  DATE          NOT NULL,
  EFCTV_END_DT                    DATE,
  REC_MDFD_CNT                    NUMBER(18)    NOT NULL,
  REC_CRTR_PARTY_ID               NUMBER(20)    NOT NULL,
  SRC_APLCTN_PARTY_ID             NUMBER(20)    NOT NULL,
  REC_MDFD_TYPE_CD                VARCHAR2(1 BYTE) NOT NULL,
  REC_CRTD_DT                     DATE          DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID               NUMBER(20)    NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_RULE_STATUS_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_RULE_STATUS_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_RULE_STATUS_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_RULE_STATUS_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_RULE_STATUS_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFORULESTATUS_H_PK ON CIS.CIS_CONT_INFO_RULE_STATUS_H
(CIS_CONT_INFO_RULE_STATUS_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_RULE_STATUS_H FOR CIS.CIS_CONT_INFO_RULE_STATUS_H;


ALTER TABLE CIS.CIS_CONT_INFO_RULE_STATUS_H ADD (
  CONSTRAINT CIS_CONTINFORULESTATUS_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_RULE_STATUS_H_ID)
  USING INDEX CIS.CIS_CONTINFORULESTATUS_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_RULE_STATUS_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_RULE_STATUS_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_RULE_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_RULE_STATUS CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_RULE_STATUS
(
  CIS_CONT_INFO_RULE_STATUS_ID  NUMBER(20)      NOT NULL,
  CIS_CONT_INFO_STATUS_ID       NUMBER(20)      NOT NULL,
  CIS_RULE_TYPE_ID              NUMBER(20)      NOT NULL,
  CIS_STAT_TYPE_ID              NUMBER(20)      NOT NULL,
  EFCTV_START_DT                DATE            NOT NULL,
  EFCTV_END_DT                  DATE,
  REC_MDFD_CNT                  NUMBER(18)      NOT NULL,
  CIS_PROVENANCE_ID             NUMBER(20)      NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_RULE_STATUS.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFORULESTATUS_PK ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_CONT_INFO_RULE_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINFSTAT_RULESTAT_FK_I ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_CONT_INFO_STATUS_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_RULETYPE_INFORULESTAT_FK_I ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_RULE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_STATTYPE_INFORULESTAT_FK_I ON CIS.CIS_CONT_INFO_RULE_STATUS
(CIS_STAT_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_RULE__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_RULE_STATUS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_RULE_STATUS_H( CIS_CONT_INFO_RULE_STATUS_H_ID,

CIS_CONT_INFO_RULE_STATUS_ID,

CIS_CONT_INFO_STATUS_ID,


CIS_RULE_TYPE_ID,

CIS_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_RULE_STATUS_H_S.nextval
,

:old.CIS_CONT_INFO_RULE_STATUS_ID,

:old.CIS_CONT_INFO_STATUS_ID,

:old.CIS_RULE_TYPE_ID,

:old.CIS_STAT_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,
'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_RULE_STATUS_H( CIS_CONT_INFO_RULE_STATUS_H_ID,

CIS_CONT_INFO_RULE_STATUS_ID,

CIS_CONT_INFO_STATUS_ID,


CIS_RULE_TYPE_ID,

CIS_STAT_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_RULE_STATUS_H_S.nextval
,

:new.CIS_CONT_INFO_RULE_STATUS_ID,

:new.CIS_CONT_INFO_STATUS_ID,

:new.CIS_RULE_TYPE_ID,

:new.CIS_STAT_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,
mDML);
end if;
end CIS_CONT_INFO_RULE__AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_RULE_STATUS FOR CIS.CIS_CONT_INFO_RULE_STATUS;


ALTER TABLE CIS.CIS_CONT_INFO_RULE_STATUS ADD (
  CONSTRAINT CIS_CONTINFORULESTATUS_PK
  PRIMARY KEY
  (CIS_CONT_INFO_RULE_STATUS_ID)
  USING INDEX CIS.CIS_CONTINFORULESTATUS_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_RULE_STATUS ADD (
  CONSTRAINT CIS_CONTINFSTAT_RULESTAT_FK 
  FOREIGN KEY (CIS_CONT_INFO_STATUS_ID) 
  REFERENCES CIS.CIS_CONT_INFO_STATUS (CIS_CONT_INFO_STATUS_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFORLST_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_RULETYPE_INFORULESTAT_FK 
  FOREIGN KEY (CIS_RULE_TYPE_ID) 
  REFERENCES CIS.CIS_RULE_TYPE (CIS_RULE_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_STATTYPE_INFORULESTAT_FK 
  FOREIGN KEY (CIS_STAT_TYPE_ID) 
  REFERENCES CIS.CIS_STAT_TYPE (CIS_STAT_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_RULE_STATUS TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_RULE_STATUS TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PURPOSE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PURPOSE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PURPOSE_H
(
  CIS_CONT_INFO_PURPOSE_H_ID  NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_PURPOSE_ID    NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_ID            NUMBER(20)        NOT NULL,
  CIS_PURP_TYPE_ID            NUMBER(20)        NOT NULL,
  EFCTV_START_DT              DATE              NOT NULL,
  EFCTV_END_DT                DATE,
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  REC_CRTR_PARTY_ID           NUMBER(20)        NOT NULL,
  SRC_APLCTN_PARTY_ID         NUMBER(20)        NOT NULL,
  REC_MDFD_TYPE_CD            VARCHAR2(1 BYTE)  NOT NULL,
  REC_CRTD_DT                 DATE              DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PURPOSE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PURPOSE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PURPOSE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PURPOSE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PURPOSE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPURPOSE_H_PK ON CIS.CIS_CONT_INFO_PURPOSE_H
(CIS_CONT_INFO_PURPOSE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PURPOSE_H FOR CIS.CIS_CONT_INFO_PURPOSE_H;


ALTER TABLE CIS.CIS_CONT_INFO_PURPOSE_H ADD (
  CONSTRAINT CIS_CONTINFOPURPOSE_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PURPOSE_H_ID)
  USING INDEX CIS.CIS_CONTINFOPURPOSE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PURPOSE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PURPOSE_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PURPOSE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PURPOSE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PURPOSE
(
  CIS_CONT_INFO_PURPOSE_ID  NUMBER(20)          NOT NULL,
  CIS_CONT_INFO_ID          NUMBER(20)          NOT NULL,
  CIS_PURP_TYPE_ID          NUMBER(20)          NOT NULL,
  EFCTV_START_DT            DATE                NOT NULL,
  EFCTV_END_DT              DATE,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PURPOSE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPURPOSE_PK ON CIS.CIS_CONT_INFO_PURPOSE
(CIS_CONT_INFO_PURPOSE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINFO_PURP_FK_I ON CIS.CIS_CONT_INFO_PURPOSE
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PURPTYP_CONTINFOPRPS_FK_I ON CIS.CIS_CONT_INFO_PURPOSE
(CIS_PURP_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PURPO_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PURPOSE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PURPOSE_H( CIS_CONT_INFO_PURPOSE_H_ID,

CIS_CONT_INFO_PURPOSE_ID,

CIS_CONT_INFO_ID,


CIS_PURP_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PURPOSE_H_S.nextval
,

:old.CIS_CONT_INFO_PURPOSE_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_PURP_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PURPOSE_H( CIS_CONT_INFO_PURPOSE_H_ID,

CIS_CONT_INFO_PURPOSE_ID,

CIS_CONT_INFO_ID,


CIS_PURP_TYPE_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PURPOSE_H_S.nextval
,

:new.CIS_CONT_INFO_PURPOSE_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_PURP_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_PURPO_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PURPOSE FOR CIS.CIS_CONT_INFO_PURPOSE;


ALTER TABLE CIS.CIS_CONT_INFO_PURPOSE ADD (
  CONSTRAINT CIS_CONTINFOPURPOSE_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PURPOSE_ID)
  USING INDEX CIS.CIS_CONTINFOPURPOSE_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_PURPOSE ADD (
  CONSTRAINT CIS_CONTINFO_PURP_FK 
  FOREIGN KEY (CIS_CONT_INFO_ID) 
  REFERENCES CIS.CIS_CONT_INFO (CIS_CONT_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOPRPS_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PURPTYP_CONTINFOPRPS_FK 
  FOREIGN KEY (CIS_PURP_TYPE_ID) 
  REFERENCES CIS.CIS_PURPOSE_TYPE (CIS_PURP_TYPE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PURPOSE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PURPOSE TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PROF_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PROF_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PROF_H
(
  CIS_CONT_INFO_PROF_H_ID  NUMBER(20)           NOT NULL,
  CIS_CONT_INFO_PROF_ID    NUMBER(20)           NOT NULL,
  CIS_PARTY_ID             NUMBER(20)           NOT NULL,
  EFCTV_START_DT           DATE                 NOT NULL,
  EFCTV_END_DT             DATE,
  REC_MDFD_CNT             NUMBER(18)           NOT NULL,
  REC_CRTR_PARTY_ID        NUMBER(20)           NOT NULL,
  SRC_APLCTN_PARTY_ID      NUMBER(20)           NOT NULL,
  REC_MDFD_TYPE_CD         VARCHAR2(1 BYTE)     NOT NULL,
  REC_CRTD_DT              DATE                 DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID        NUMBER(20)           NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PROF_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PROF_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PROF_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PROF_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PROF_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPROF_H_PK ON CIS.CIS_CONT_INFO_PROF_H
(CIS_CONT_INFO_PROF_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PROF_H FOR CIS.CIS_CONT_INFO_PROF_H;


ALTER TABLE CIS.CIS_CONT_INFO_PROF_H ADD (
  CONSTRAINT CIS_CONTINFOPROF_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PROF_H_ID)
  USING INDEX CIS.CIS_CONTINFOPROF_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PROF_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PROF_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PROF
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PROF CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PROF
(
  CIS_CONT_INFO_PROF_ID  NUMBER(20)             NOT NULL,
  CIS_PARTY_ID           NUMBER(20)             NOT NULL,
  EFCTV_START_DT         DATE                   NOT NULL,
  EFCTV_END_DT           DATE,
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PROF.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPROF_PK ON CIS.CIS_CONT_INFO_PROF
(CIS_CONT_INFO_PROF_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTY_CONTINFOPROF_FK_I ON CIS.CIS_CONT_INFO_PROF
(CIS_PARTY_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PROF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PROF
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PROF_H( CIS_CONT_INFO_PROF_H_ID,

CIS_CONT_INFO_PROF_ID,

CIS_PARTY_ID,

EFCTV_START_DT,


EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_PROF_H_S.nextval
,

:old.CIS_CONT_INFO_PROF_ID,

:old.CIS_PARTY_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PROF_H( CIS_CONT_INFO_PROF_H_ID,

CIS_CONT_INFO_PROF_ID,

CIS_PARTY_ID,

EFCTV_START_DT,


EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_PROF_H_S.nextval
,

:new.CIS_CONT_INFO_PROF_ID,

:new.CIS_PARTY_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_PROF_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PROF FOR CIS.CIS_CONT_INFO_PROF;


ALTER TABLE CIS.CIS_CONT_INFO_PROF ADD (
  CONSTRAINT CIS_CONTINFOPROF_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PROF_ID)
  USING INDEX CIS.CIS_CONTINFOPROF_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_PROF ADD (
  CONSTRAINT CIS_PARTY_CONTINFOPROF_FK 
  FOREIGN KEY (CIS_PARTY_ID) 
  REFERENCES CIS.CIS_PARTY (CIS_PARTY_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOPRFL_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PROF TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PROF TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PREF_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PREF_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PREF_H
(
  CIS_CONT_INFO_PREF_H_ID  NUMBER(20)           NOT NULL,
  CIS_CONT_INFO_PREF_ID    NUMBER(20)           NOT NULL,
  CIS_CONT_INFO_ID         NUMBER(20)           NOT NULL,
  CIS_PREF_TYPE_ID         NUMBER(20)           NOT NULL,
  EFCTV_START_DT           DATE                 NOT NULL,
  EFCTV_END_DT             DATE,
  REC_MDFD_CNT             NUMBER(18)           NOT NULL,
  REC_CRTR_PARTY_ID        NUMBER(20)           NOT NULL,
  SRC_APLCTN_PARTY_ID      NUMBER(20)           NOT NULL,
  REC_MDFD_TYPE_CD         VARCHAR2(1 BYTE)     NOT NULL,
  REC_CRTD_DT              DATE                 DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID        NUMBER(20)           NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PREF_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PREF_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PREF_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PREF_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PREF_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPREF_H_PK ON CIS.CIS_CONT_INFO_PREF_H
(CIS_CONT_INFO_PREF_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PREF_H FOR CIS.CIS_CONT_INFO_PREF_H;


ALTER TABLE CIS.CIS_CONT_INFO_PREF_H ADD (
  CONSTRAINT CIS_CONTINFOPREF_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PREF_H_ID)
  USING INDEX CIS.CIS_CONTINFOPREF_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PREF_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PREF_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PREF
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PREF CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PREF
(
  CIS_CONT_INFO_PREF_ID  NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_ID       NUMBER(20)             NOT NULL,
  CIS_PREF_TYPE_ID       NUMBER(20)             NOT NULL,
  EFCTV_START_DT         DATE                   NOT NULL,
  EFCTV_END_DT           DATE,
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PREF.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPREF_PK ON CIS.CIS_CONT_INFO_PREF
(CIS_CONT_INFO_PREF_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOPREF_UK ON CIS.CIS_CONT_INFO_PREF
(CIS_CONT_INFO_ID, CIS_PREF_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINFO_INFOPREF_FK_I ON CIS.CIS_CONT_INFO_PREF
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PREFTYPE_INFOPREF_FK_I ON CIS.CIS_CONT_INFO_PREF
(CIS_PREF_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PREF_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PREF
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PREF_H( CIS_CONT_INFO_PREF_H_ID,

CIS_CONT_INFO_PREF_ID,

CIS_CONT_INFO_ID,

CIS_PREF_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PREF_H_S.nextval
,

:old.CIS_CONT_INFO_PREF_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_PREF_TYPE_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PREF_H( CIS_CONT_INFO_PREF_H_ID,

CIS_CONT_INFO_PREF_ID,

CIS_CONT_INFO_ID,

CIS_PREF_TYPE_ID,


EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PREF_H_S.nextval
,

:new.CIS_CONT_INFO_PREF_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_PREF_TYPE_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_PREF_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PREF FOR CIS.CIS_CONT_INFO_PREF;


ALTER TABLE CIS.CIS_CONT_INFO_PREF ADD (
  CONSTRAINT CIS_CONTINFOPREF_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PREF_ID)
  USING INDEX CIS.CIS_CONTINFOPREF_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_CONTINFOPREF_UK
  UNIQUE (CIS_CONT_INFO_ID, CIS_PREF_TYPE_ID)
  USING INDEX CIS.CIS_CONTINFOPREF_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_PREF ADD (
  CONSTRAINT CIS_CONTINFO_INFOPREF_FK 
  FOREIGN KEY (CIS_CONT_INFO_ID) 
  REFERENCES CIS.CIS_CONT_INFO (CIS_CONT_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PREFTYPE_INFOPREF_FK 
  FOREIGN KEY (CIS_PREF_TYPE_ID) 
  REFERENCES CIS.CIS_PREF_TYPE (CIS_PREF_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOPREF_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PREF TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PREF TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PHONE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PHONE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PHONE_H
(
  CIS_CONT_INFO_PHONE_H_ID  NUMBER(20)          NOT NULL,
  CIS_CONT_INFO_PHONE_ID    NUMBER(20)          NOT NULL,
  CIS_CONT_INFO_ID          NUMBER(20)          NOT NULL,
  CIS_PHONE_TYPE_ID         NUMBER(20)          NOT NULL,
  COUNTRY_CD                NUMBER(2)           NOT NULL,
  AREA_CD                   NUMBER(3),
  EXCHANGE_CD               NUMBER(3),
  END_POINT_RN              NUMBER(4),
  EXTNTN_NO                 NUMBER(10),
  COMPLT_PHONE_NO           VARCHAR2(30 BYTE)   NOT NULL,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  REC_CRTR_PARTY_ID         NUMBER(20)          NOT NULL,
  SRC_APLCTN_PARTY_ID       NUMBER(20)          NOT NULL,
  REC_MDFD_TYPE_CD          VARCHAR2(1 BYTE)    NOT NULL,
  REC_CRTD_DT               DATE                DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PHONE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PHONE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PHONE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PHONE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PHONE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPHONE_H_PK ON CIS.CIS_CONT_INFO_PHONE_H
(CIS_CONT_INFO_PHONE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PHONE_H FOR CIS.CIS_CONT_INFO_PHONE_H;


ALTER TABLE CIS.CIS_CONT_INFO_PHONE_H ADD (
  CONSTRAINT CIS_CONTINFOPHONE_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PHONE_H_ID)
  USING INDEX CIS.CIS_CONTINFOPHONE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PHONE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PHONE_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_PHONE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_PHONE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_PHONE
(
  CIS_CONT_INFO_PHONE_ID  NUMBER(20)            NOT NULL,
  CIS_CONT_INFO_ID        NUMBER(20)            NOT NULL,
  CIS_PHONE_TYPE_ID       NUMBER(20)            NOT NULL,
  COUNTRY_CD              NUMBER(2)             NOT NULL,
  AREA_CD                 NUMBER(3),
  EXCHANGE_CD             NUMBER(3),
  END_POINT_RN            NUMBER(4),
  EXTNTN_NO               NUMBER(10),
  COMPLT_PHONE_NO         VARCHAR2(30 BYTE)     NOT NULL,
  REC_MDFD_CNT            NUMBER(18)            NOT NULL,
  CIS_PROVENANCE_ID       NUMBER(20)            NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_PHONE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOPHONE_PK ON CIS.CIS_CONT_INFO_PHONE
(CIS_CONT_INFO_PHONE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINF_CONTINFPHONE_FK_I ON CIS.CIS_CONT_INFO_PHONE
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PHONETYPE_CONTINFOPH_FK_I ON CIS.CIS_CONT_INFO_PHONE
(CIS_PHONE_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_PHONE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_PHONE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PHONE_H( CIS_CONT_INFO_PHONE_H_ID,

CIS_CONT_INFO_PHONE_ID,

CIS_CONT_INFO_ID,

CIS_PHONE_TYPE_ID,


COUNTRY_CD,

AREA_CD,

EXCHANGE_CD,

END_POINT_RN,

EXTNTN_NO,

COMPLT_PHONE_NO,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PHONE_H_S.nextval
,

:old.CIS_CONT_INFO_PHONE_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_PHONE_TYPE_ID,

:old.COUNTRY_CD,

:old.AREA_CD,

:old.EXCHANGE_CD,


:old.END_POINT_RN,

:old.EXTNTN_NO,

:old.COMPLT_PHONE_NO,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_PHONE_H( CIS_CONT_INFO_PHONE_H_ID,

CIS_CONT_INFO_PHONE_ID,

CIS_CONT_INFO_ID,

CIS_PHONE_TYPE_ID,


COUNTRY_CD,

AREA_CD,

EXCHANGE_CD,

END_POINT_RN,

EXTNTN_NO,

COMPLT_PHONE_NO,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_PHONE_H_S.nextval
,

:new.CIS_CONT_INFO_PHONE_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_PHONE_TYPE_ID,

:new.COUNTRY_CD,

:new.AREA_CD,

:new.EXCHANGE_CD,


:new.END_POINT_RN,

:new.EXTNTN_NO,

:new.COMPLT_PHONE_NO,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_PHONE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_PHONE FOR CIS.CIS_CONT_INFO_PHONE;


ALTER TABLE CIS.CIS_CONT_INFO_PHONE ADD (
  CONSTRAINT CIS_CONTINFOPHONE_PK
  PRIMARY KEY
  (CIS_CONT_INFO_PHONE_ID)
  USING INDEX CIS.CIS_CONTINFOPHONE_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_PHONE ADD (
  CONSTRAINT CIS_CONTINF_CONTINFPHONE_FK 
  FOREIGN KEY (CIS_CONT_INFO_ID) 
  REFERENCES CIS.CIS_CONT_INFO (CIS_CONT_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PHONETYPE_CONTINFOPH_FK 
  FOREIGN KEY (CIS_PHONE_TYPE_ID) 
  REFERENCES CIS.CIS_PHONE_TYPE (CIS_PHONE_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOPHN_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_PHONE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_PHONE TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_H
(
  CIS_CONT_INFO_H_ID     NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_ID       NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_TYPE_ID  NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_PROF_ID  NUMBER(20)             NOT NULL,
  SRC_PARTY_INFO_ID      NUMBER(20)             NOT NULL,
  CIS_PARTY_RLNSHP_ID    NUMBER(20),
  EFCTV_START_DT         DATE                   NOT NULL,
  EFCTV_END_DT           DATE,
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  REC_CRTR_PARTY_ID      NUMBER(20)             NOT NULL,
  SRC_APLCTN_PARTY_ID    NUMBER(20)             NOT NULL,
  REC_MDFD_TYPE_CD       VARCHAR2(1 BYTE)       NOT NULL,
  REC_CRTD_DT            DATE                   DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_H_ID_PK ON CIS.CIS_CONT_INFO_H
(CIS_CONT_INFO_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_H FOR CIS.CIS_CONT_INFO_H;


ALTER TABLE CIS.CIS_CONT_INFO_H ADD (
  CONSTRAINT CIS_CONT_INFO_H_ID_PK
  PRIMARY KEY
  (CIS_CONT_INFO_H_ID)
  USING INDEX CIS.CIS_CONT_INFO_H_ID_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_EMAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_EMAIL_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_EMAIL_H
(
  CIS_CONT_INFO_EMAIL_H_ID  NUMBER(20)          NOT NULL,
  CIS_CONT_INFO_EMAIL_ID    NUMBER(20)          NOT NULL,
  CIS_EMAIL_TYPE_ID         NUMBER(20)          NOT NULL,
  CIS_CONT_INFO_ID          NUMBER(20)          NOT NULL,
  EMAIL_ADDR_TX             VARCHAR2(255 BYTE)  NOT NULL,
  REC_MDFD_CNT              NUMBER(18)          NOT NULL,
  REC_CRTR_PARTY_ID         NUMBER(20)          NOT NULL,
  SRC_APLCTN_PARTY_ID       NUMBER(20)          NOT NULL,
  REC_MDFD_TYPE_CD          VARCHAR2(1 BYTE)    NOT NULL,
  REC_CRTD_DT               DATE                DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID         NUMBER(20)          NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_EMAIL_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_EMAIL_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_EMAIL_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_EMAIL_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_EMAIL_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOEMAIL_H_PK ON CIS.CIS_CONT_INFO_EMAIL_H
(CIS_CONT_INFO_EMAIL_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_EMAIL_H FOR CIS.CIS_CONT_INFO_EMAIL_H;


ALTER TABLE CIS.CIS_CONT_INFO_EMAIL_H ADD (
  CONSTRAINT CIS_CONTINFOEMAIL_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_EMAIL_H_ID)
  USING INDEX CIS.CIS_CONTINFOEMAIL_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_EMAIL_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_EMAIL_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_EMAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_EMAIL CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_EMAIL
(
  CIS_CONT_INFO_EMAIL_ID  NUMBER(20)            NOT NULL,
  CIS_EMAIL_TYPE_ID       NUMBER(20)            NOT NULL,
  CIS_CONT_INFO_ID        NUMBER(20)            NOT NULL,
  EMAIL_ADDR_TX           VARCHAR2(255 BYTE)    NOT NULL,
  REC_MDFD_CNT            NUMBER(18)            NOT NULL,
  CIS_PROVENANCE_ID       NUMBER(20)            NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_EMAIL.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOEMAIL_PK ON CIS.CIS_CONT_INFO_EMAIL
(CIS_CONT_INFO_EMAIL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINF_CONTINFEMAIL_FK_I ON CIS.CIS_CONT_INFO_EMAIL
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_EMAILTYP_CONTINFEMAIL_FK_I ON CIS.CIS_CONT_INFO_EMAIL
(CIS_EMAIL_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_EMAIL_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_EMAIL
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_EMAIL_H( CIS_CONT_INFO_EMAIL_H_ID,

CIS_CONT_INFO_EMAIL_ID,

CIS_EMAIL_TYPE_ID,

CIS_CONT_INFO_ID,


EMAIL_ADDR_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_EMAIL_H_S.nextval
,

:old.CIS_CONT_INFO_EMAIL_ID,

:old.CIS_EMAIL_TYPE_ID,

:old.CIS_CONT_INFO_ID,

:old.EMAIL_ADDR_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_EMAIL_H( CIS_CONT_INFO_EMAIL_H_ID,

CIS_CONT_INFO_EMAIL_ID,

CIS_EMAIL_TYPE_ID,

CIS_CONT_INFO_ID,


EMAIL_ADDR_TX,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID ,
REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_EMAIL_H_S.nextval
,

:new.CIS_CONT_INFO_EMAIL_ID,

:new.CIS_EMAIL_TYPE_ID,

:new.CIS_CONT_INFO_ID,

:new.EMAIL_ADDR_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_EMAIL_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_EMAIL FOR CIS.CIS_CONT_INFO_EMAIL;


ALTER TABLE CIS.CIS_CONT_INFO_EMAIL ADD (
  CONSTRAINT CIS_CONTINFOEMAIL_PK
  PRIMARY KEY
  (CIS_CONT_INFO_EMAIL_ID)
  USING INDEX CIS.CIS_CONTINFOEMAIL_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_EMAIL ADD (
  CONSTRAINT CIS_CONTINF_CONTINFEMAIL_FK 
  FOREIGN KEY (CIS_CONT_INFO_ID) 
  REFERENCES CIS.CIS_CONT_INFO (CIS_CONT_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_EMAILTYP_CONTINFEMAIL_FK 
  FOREIGN KEY (CIS_EMAIL_TYPE_ID) 
  REFERENCES CIS.CIS_EMAIL_TYPE (CIS_EMAIL_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOEMAIL_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_EMAIL TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_EMAIL TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_DATA_QUALITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_DATA_QUALITY_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_DATA_QUALITY_H
(
  CIS_CONT_INFO_DATA_QUAL_H_ID  NUMBER(20)      NOT NULL,
  CIS_CONT_INFO_DATA_QUAL_ID    NUMBER(20)      NOT NULL,
  CIS_INFLGHT_DATA_ID           NUMBER(20)      NOT NULL,
  CIS_CONT_INFO_ID              NUMBER(20),
  EFCTV_START_DT                DATE            NOT NULL,
  EFCTV_END_DT                  DATE,
  RATING_SC                     NUMBER(20),
  REC_MDFD_CNT                  NUMBER(18)      NOT NULL,
  REC_CRTR_PARTY_ID             NUMBER(20)      NOT NULL,
  SRC_APLCTN_PARTY_ID           NUMBER(20)      NOT NULL,
  REC_MDFD_TYPE_CD              VARCHAR2(1 BYTE) NOT NULL,
  REC_CRTD_DT                   DATE            DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID             NUMBER(20)      NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_DATA_QUALITY_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_DATA_QUALITY_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_DATA_QUALITY_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_DATA_QUALITY_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_DATA_QUALITY_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFODATAQUAL_H_PK ON CIS.CIS_CONT_INFO_DATA_QUALITY_H
(CIS_CONT_INFO_DATA_QUAL_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_DATA_QUALITY_H FOR CIS.CIS_CONT_INFO_DATA_QUALITY_H;


ALTER TABLE CIS.CIS_CONT_INFO_DATA_QUALITY_H ADD (
  CONSTRAINT CIS_CONTINFODATAQUAL_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_DATA_QUAL_H_ID)
  USING INDEX CIS.CIS_CONTINFODATAQUAL_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_DATA_QUALITY_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_DATA_QUALITY_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_DATA_QUALITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_DATA_QUALITY CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_DATA_QUALITY
(
  CIS_CONT_INFO_DATA_QUAL_ID  NUMBER(20)        NOT NULL,
  CIS_INFLGHT_DATA_ID         NUMBER(20)        NOT NULL,
  CIS_CONT_INFO_ID            NUMBER(20),
  EFCTV_START_DT              DATE              NOT NULL,
  EFCTV_END_DT                DATE,
  RATING_SC                   NUMBER(20),
  REC_MDFD_CNT                NUMBER(18)        NOT NULL,
  CIS_PROVENANCE_ID           NUMBER(20)        NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_DATA_QUALITY.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_CONTINFODATAQUAL_PK ON CIS.CIS_CONT_INFO_DATA_QUALITY
(CIS_CONT_INFO_DATA_QUAL_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINFO_DATAQUAL_FK_I ON CIS.CIS_CONT_INFO_DATA_QUALITY
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_INFLGHT_CI_DQ_FK_I ON CIS.CIS_CONT_INFO_DATA_QUALITY
(CIS_INFLGHT_DATA_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_DATA__AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_DATA_QUALITY
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_DATA_QUALITY_H( CIS_CONT_INFO_DATA_QUAL_H_ID,

CIS_CONT_INFO_DATA_QUAL_ID,

CIS_INFLGHT_DATA_ID,


CIS_CONT_INFO_ID,

EFCTV_START_DT,

EFCTV_END_DT,

RATING_SC,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_DATA_QUALITY_H_S.nextval
,

:old.CIS_CONT_INFO_DATA_QUAL_ID,

:old.CIS_INFLGHT_DATA_ID,

:old.CIS_CONT_INFO_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.RATING_SC,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_DATA_QUALITY_H( CIS_CONT_INFO_DATA_QUAL_H_ID,

CIS_CONT_INFO_DATA_QUAL_ID,

CIS_INFLGHT_DATA_ID,


CIS_CONT_INFO_ID,

EFCTV_START_DT,

EFCTV_END_DT,

RATING_SC,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_DATA_QUALITY_H_S.nextval
,

:new.CIS_CONT_INFO_DATA_QUAL_ID,

:new.CIS_INFLGHT_DATA_ID,

:new.CIS_CONT_INFO_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.RATING_SC,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_DATA__AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_DATA_QUALITY FOR CIS.CIS_CONT_INFO_DATA_QUALITY;


ALTER TABLE CIS.CIS_CONT_INFO_DATA_QUALITY ADD (
  CONSTRAINT CIS_CONTINFODATAQUAL_PK
  PRIMARY KEY
  (CIS_CONT_INFO_DATA_QUAL_ID)
  USING INDEX CIS.CIS_CONTINFODATAQUAL_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_DATA_QUALITY ADD (
  CONSTRAINT CIS_CONTINFO_DATAQUAL_FK 
  FOREIGN KEY (CIS_CONT_INFO_ID) 
  REFERENCES CIS.CIS_CONT_INFO (CIS_CONT_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_INFLGHT_CI_DQ_FK 
  FOREIGN KEY (CIS_INFLGHT_DATA_ID) 
  REFERENCES CIS.CIS_INFLGHT_DATA (CIS_INFLGHT_DATA_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFODQ_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_DATA_QUALITY TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_DATA_QUALITY TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_ADDRESS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_ADDRESS_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_ADDRESS_H
(
  CIS_CONT_INFO_ADDR_H_ID  NUMBER(20)           NOT NULL,
  CIS_CONT_INFO_ADDR_ID    NUMBER(20)           NOT NULL,
  CIS_CONT_INFO_ID         NUMBER(20)           NOT NULL,
  CIS_ADDRESS_TYPE_ID      NUMBER(20)           NOT NULL,
  LINE_1                   VARCHAR2(100 BYTE)   NOT NULL,
  LINE_2                   VARCHAR2(100 BYTE),
  LINE_3                   VARCHAR2(100 BYTE),
  LINE_4                   VARCHAR2(100 BYTE),
  IN_CARE_OF_TX            VARCHAR2(100 BYTE),
  ATTN_TO_TX               VARCHAR2(100 BYTE),
  CITY_TX                  VARCHAR2(100 BYTE)   NOT NULL,
  STATE_PRVNC_TX           VARCHAR2(100 BYTE),
  ZIP_5_CD                 VARCHAR2(5 BYTE),
  ZIP_4_CD                 VARCHAR2(4 BYTE),
  POSTAL_CD                VARCHAR2(20 BYTE),
  COUNTY_DISTRICT_TX       VARCHAR2(100 BYTE),
  PRVNC_TX                 VARCHAR2(100 BYTE),
  TERTRY_TX                VARCHAR2(100 BYTE),
  COUNTRY_CD_TX            VARCHAR2(100 BYTE)   NOT NULL,
  GEO_CD_TX                VARCHAR2(100 BYTE),
  ADDR_BLOB_TX             VARCHAR2(500 BYTE),
  REC_MDFD_CNT             NUMBER(18)           NOT NULL,
  REC_CRTR_PARTY_ID        NUMBER(20)           NOT NULL,
  SRC_APLCTN_PARTY_ID      NUMBER(20)           NOT NULL,
  REC_MDFD_TYPE_CD         VARCHAR2(1 BYTE)     NOT NULL,
  REC_CRTD_DT              DATE                 DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID        NUMBER(20)           NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_CONTINFOADDR_H_PK ON CIS.CIS_CONT_INFO_ADDRESS_H
(CIS_CONT_INFO_ADDR_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_ADDRESS_H FOR CIS.CIS_CONT_INFO_ADDRESS_H;


ALTER TABLE CIS.CIS_CONT_INFO_ADDRESS_H ADD (
  CONSTRAINT CIS_CONTINFOADDR_H_PK
  PRIMARY KEY
  (CIS_CONT_INFO_ADDR_H_ID)
  USING INDEX CIS.CIS_CONTINFOADDR_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_ADDRESS_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_ADDRESS_H TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO_ADDRESS
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO_ADDRESS CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO_ADDRESS
(
  CIS_CONT_INFO_ADDR_ID  NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_ID       NUMBER(20)             NOT NULL,
  CIS_ADDRESS_TYPE_ID    NUMBER(20)             NOT NULL,
  LINE_1                 VARCHAR2(100 BYTE)     NOT NULL,
  LINE_2                 VARCHAR2(100 BYTE),
  LINE_3                 VARCHAR2(100 BYTE),
  LINE_4                 VARCHAR2(100 BYTE),
  CITY_TX                VARCHAR2(100 BYTE)     NOT NULL,
  STATE_PRVNC_TX         VARCHAR2(100 BYTE),
  ZIP_5_CD               VARCHAR2(5 BYTE),
  ZIP_4_CD               VARCHAR2(4 BYTE),
  POSTAL_CD              VARCHAR2(20 BYTE),
  COUNTY_DISTRICT_TX     VARCHAR2(100 BYTE),
  PRVNC_TX               VARCHAR2(100 BYTE),
  TERTRY_TX              VARCHAR2(100 BYTE),
  COUNTRY_CD_TX          VARCHAR2(100 BYTE)     NOT NULL,
  ATTN_TO_TX             VARCHAR2(100 BYTE),
  IN_CARE_OF_TX          VARCHAR2(100 BYTE),
  GEO_CD_TX              VARCHAR2(100 BYTE),
  ADDR_BLOB_TX           VARCHAR2(500 BYTE),
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS.POSTAL_CD IS 'postalCode, zip, zip+4';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS.COUNTY_DISTRICT_TX IS 'district, county, suburb/urbanization code / Subregion for international';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS.ADDR_BLOB_TX IS 'Whole address in one block.';

COMMENT ON COLUMN CIS.CIS_CONT_INFO_ADDRESS.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE INDEX CIS.CIS_ADDRTYPE_CONTINFOADDR_FK_I ON CIS.CIS_CONT_INFO_ADDRESS
(CIS_ADDRESS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_CONTINFOADDR_PK ON CIS.CIS_CONT_INFO_ADDRESS
(CIS_CONT_INFO_ADDR_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINFO_CONTINFOADDR_FK_I ON CIS.CIS_CONT_INFO_ADDRESS
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_ADDRE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO_ADDRESS
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);

V_SRC_APLCTN_PARTY_ID      NUMBER(22);


begin
if  deleting then
select REC_CRTD_DT,REC_CRTR_PARTY_ID,SRC_APLCTN_PARTY_ID INTO  V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,V_SRC_APLCTN_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_ADDRESS_H( CIS_CONT_INFO_ADDR_H_ID,

CIS_CONT_INFO_ADDR_ID,

CIS_CONT_INFO_ID,

CIS_ADDRESS_TYPE_ID,


LINE_1,

LINE_2,

LINE_3,

LINE_4,

CITY_TX,

STATE_PRVNC_TX,

ZIP_5_CD,

ZIP_4_CD,

POSTAL_CD,

COUNTY_DISTRICT_TX,


PRVNC_TX,

TERTRY_TX,

COUNTRY_CD_TX,

ATTN_TO_TX,

IN_CARE_OF_TX,

GEO_CD_TX,

ADDR_BLOB_TX,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

REC_CRTD_DT,REC_CRTR_PARTY_ID,SRC_APLCTN_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_ADDRESS_H_S.nextval
,

:old.CIS_CONT_INFO_ADDR_ID,

:old.CIS_CONT_INFO_ID,

:old.CIS_ADDRESS_TYPE_ID,

:old.LINE_1,

:old.LINE_2,

:old.LINE_3,

:old.LINE_4,

:old.CITY_TX,

:old.STATE_PRVNC_TX,

:old.ZIP_5_CD,

:old.ZIP_4_CD,

:old.POSTAL_CD,

:old.COUNTY_DISTRICT_TX,

:old.PRVNC_TX
,

:old.TERTRY_TX,

:old.COUNTRY_CD_TX,

:old.ATTN_TO_TX,

:old.IN_CARE_OF_TX,

:old.GEO_CD_TX,

:old.ADDR_BLOB_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,V_SRC_APLCTN_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select REC_CRTD_DT,REC_CRTR_PARTY_ID,SRC_APLCTN_PARTY_ID INTO  V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,V_SRC_APLCTN_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_ADDRESS_H( CIS_CONT_INFO_ADDR_H_ID,

CIS_CONT_INFO_ADDR_ID,

CIS_CONT_INFO_ID,

CIS_ADDRESS_TYPE_ID,


LINE_1,

LINE_2,

LINE_3,

LINE_4,

CITY_TX,

STATE_PRVNC_TX,

ZIP_5_CD,

ZIP_4_CD,

POSTAL_CD,

COUNTY_DISTRICT_TX,


PRVNC_TX,

TERTRY_TX,

COUNTRY_CD_TX,

ATTN_TO_TX,

IN_CARE_OF_TX,

GEO_CD_TX,

ADDR_BLOB_TX,

REC_MDFD_CNT,


CIS_PROVENANCE_ID,

REC_CRTD_DT,REC_CRTR_PARTY_ID,SRC_APLCTN_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_CONT_INFO_ADDRESS_H_S.nextval
,

:new.CIS_CONT_INFO_ADDR_ID,

:new.CIS_CONT_INFO_ID,

:new.CIS_ADDRESS_TYPE_ID,

:new.LINE_1,

:new.LINE_2,

:new.LINE_3,

:new.LINE_4,

:new.CITY_TX,

:new.STATE_PRVNC_TX,

:new.ZIP_5_CD,

:new.ZIP_4_CD,

:new.POSTAL_CD,

:new.COUNTY_DISTRICT_TX,

:new.PRVNC_TX
,

:new.TERTRY_TX,

:new.COUNTRY_CD_TX,

:new.ATTN_TO_TX,

:new.IN_CARE_OF_TX,

:new.GEO_CD_TX,

:new.ADDR_BLOB_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID,V_SRC_APLCTN_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_ADDRE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO_ADDRESS FOR CIS.CIS_CONT_INFO_ADDRESS;


ALTER TABLE CIS.CIS_CONT_INFO_ADDRESS ADD (
  CONSTRAINT CIS_CONTINFOADDR_PK
  PRIMARY KEY
  (CIS_CONT_INFO_ADDR_ID)
  USING INDEX CIS.CIS_CONTINFOADDR_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO_ADDRESS ADD (
  CONSTRAINT CIS_ADDRTYPE_CONTINFOADDR_FK 
  FOREIGN KEY (CIS_ADDRESS_TYPE_ID) 
  REFERENCES CIS.CIS_ADDRESS_TYPE (CIS_ADDRESS_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_CONTINFO_CONTINFOADDR_FK 
  FOREIGN KEY (CIS_CONT_INFO_ID) 
  REFERENCES CIS.CIS_CONT_INFO (CIS_CONT_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFOADR_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO_ADDRESS TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO_ADDRESS TO CIS_RW;
ALTER TABLE CIS.CIS_CONT_INFO
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_CONT_INFO CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_CONT_INFO
(
  CIS_CONT_INFO_ID       NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_TYPE_ID  NUMBER(20)             NOT NULL,
  CIS_CONT_INFO_PROF_ID  NUMBER(20)             NOT NULL,
  SRC_PARTY_INFO_ID      NUMBER(20)             NOT NULL,
  CIS_PARTY_RLNSHP_ID    NUMBER(20),
  EFCTV_START_DT         DATE                   NOT NULL,
  EFCTV_END_DT           DATE,
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_CONT_INFO.SRC_PARTY_INFO_ID IS 'This is the key from source system, for example, for corporate, this can be pointing to PTCPNT_ID, for Enrollment, this could be pointing to EDIPI';

COMMENT ON COLUMN CIS.CIS_CONT_INFO.CIS_PARTY_RLNSHP_ID IS 'This is used to identify related/alternate person for specific contact info.';

COMMENT ON COLUMN CIS.CIS_CONT_INFO.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE INDEX CIS.CIS_CONTINFOPROF_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(CIS_CONT_INFO_PROF_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_CONTINFOTYP_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(CIS_CONT_INFO_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_CONT_INFO_ID_PK ON CIS.CIS_CONT_INFO
(CIS_CONT_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTYINFO_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(SRC_PARTY_INFO_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PARTYRLNSHP_CONTINFO_FK_I ON CIS.CIS_CONT_INFO
(CIS_PARTY_RLNSHP_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_CONT_INFO_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_CONT_INFO
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_H( CIS_CONT_INFO_H_ID,

CIS_CONT_INFO_ID,

CIS_CONT_INFO_TYPE_ID,

CIS_CONT_INFO_PROF_ID,


SRC_PARTY_INFO_ID,

CIS_PARTY_RLNSHP_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_H_S.nextval
,

:old.CIS_CONT_INFO_ID,

:old.CIS_CONT_INFO_TYPE_ID,

:old.CIS_CONT_INFO_PROF_ID,

:old.SRC_PARTY_INFO_ID,

:old.CIS_PARTY_RLNSHP_ID,

:old.EFCTV_START_DT,

:old.EFCTV_END_DT,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_CONT_INFO_H( CIS_CONT_INFO_H_ID,

CIS_CONT_INFO_ID,

CIS_CONT_INFO_TYPE_ID,

CIS_CONT_INFO_PROF_ID,


SRC_PARTY_INFO_ID,

CIS_PARTY_RLNSHP_ID,

EFCTV_START_DT,

EFCTV_END_DT,

REC_MDFD_CNT,

CIS_PROVENANCE_ID,


SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES

(CIS_CONT_INFO_H_S.nextval
,

:new.CIS_CONT_INFO_ID,

:new.CIS_CONT_INFO_TYPE_ID,

:new.CIS_CONT_INFO_PROF_ID,

:new.SRC_PARTY_INFO_ID,

:new.CIS_PARTY_RLNSHP_ID,

:new.EFCTV_START_DT,

:new.EFCTV_END_DT,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_CONT_INFO_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_CONT_INFO FOR CIS.CIS_CONT_INFO;


ALTER TABLE CIS.CIS_CONT_INFO ADD (
  CONSTRAINT CIS_CONT_INFO_ID_PK
  PRIMARY KEY
  (CIS_CONT_INFO_ID)
  USING INDEX CIS.CIS_CONT_INFO_ID_PK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_CONT_INFO ADD (
  CONSTRAINT CIS_CONTINFOPROF_CONTINFO_FK 
  FOREIGN KEY (CIS_CONT_INFO_PROF_ID) 
  REFERENCES CIS.CIS_CONT_INFO_PROF (CIS_CONT_INFO_PROF_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_CONTINFOTYP_CONTINFO_FK 
  FOREIGN KEY (CIS_CONT_INFO_TYPE_ID) 
  REFERENCES CIS.CIS_CONT_INFO_TYPE (CIS_CONT_INFO_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTYINFO_CONTINFO_FK 
  FOREIGN KEY (SRC_PARTY_INFO_ID) 
  REFERENCES CIS.CIS_PARTY_INFO (CIS_PARTY_INFO_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PARTYRLNSHP_CONTINFO_FK 
  FOREIGN KEY (CIS_PARTY_RLNSHP_ID) 
  REFERENCES CIS.CIS_PARTY_RLNSHP (CIS_PARTY_RLNSHP_ID)
  ENABLE VALIDATE,
  CONSTRAINT CIS_PRVNC_CONTINFO_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_CONT_INFO TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_CONT_INFO TO CIS_RW;
ALTER TABLE CIS.CIS_ADDRESS_TYPE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_ADDRESS_TYPE_H CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_ADDRESS_TYPE_H
(
  CIS_ADDRESS_TYPE_H_ID  NUMBER(20)             NOT NULL,
  CIS_ADDRESS_TYPE_ID    NUMBER(20)             NOT NULL,
  ADDR_TYPE_CD           VARCHAR2(5 BYTE)       NOT NULL,
  ADDR_TYPE_NM           VARCHAR2(30 BYTE)      NOT NULL,
  ADDR_TYPE_DESC_TX      VARCHAR2(100 BYTE)     NOT NULL,
  REC_MDFD_CNT           NUMBER(18)             NOT NULL,
  REC_CRTR_PARTY_ID      NUMBER(20)             NOT NULL,
  SRC_APLCTN_PARTY_ID    NUMBER(20)             NOT NULL,
  REC_MDFD_TYPE_CD       VARCHAR2(1 BYTE)       NOT NULL,
  REC_CRTD_DT            DATE                   DEFAULT SYSDATE               NOT NULL,
  CIS_PROVENANCE_ID      NUMBER(20)             NOT NULL
)
TABLESPACE L_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_ADDRESS_TYPE_H.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';

COMMENT ON COLUMN CIS.CIS_ADDRESS_TYPE_H.REC_CRTR_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_ADDRESS_TYPE_H.SRC_APLCTN_PARTY_ID IS 'Value copied from base table';

COMMENT ON COLUMN CIS.CIS_ADDRESS_TYPE_H.REC_MDFD_TYPE_CD IS 'I - Insert, U - Update, D - Delete';

COMMENT ON COLUMN CIS.CIS_ADDRESS_TYPE_H.REC_CRTD_DT IS 'DateTime when record was created. Default value is set to Sysdate';


CREATE UNIQUE INDEX CIS.CIS_ADDRTYPE_H_PK ON CIS.CIS_ADDRESS_TYPE_H
(CIS_ADDRESS_TYPE_H_ID)
LOGGING
TABLESPACE L_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM CIS_ADDRESS_TYPE_H FOR CIS.CIS_ADDRESS_TYPE_H;


ALTER TABLE CIS.CIS_ADDRESS_TYPE_H ADD (
  CONSTRAINT CIS_ADDRTYPE_H_PK
  PRIMARY KEY
  (CIS_ADDRESS_TYPE_H_ID)
  USING INDEX CIS.CIS_ADDRTYPE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_ADDRESS_TYPE_H TO CIS_R;

GRANT INSERT, SELECT, UPDATE ON CIS.CIS_ADDRESS_TYPE_H TO CIS_RW;
ALTER TABLE CIS.CIS_ADDRESS_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE CIS.CIS_ADDRESS_TYPE CASCADE CONSTRAINTS;

CREATE TABLE CIS.CIS_ADDRESS_TYPE
(
  CIS_ADDRESS_TYPE_ID  NUMBER(20)               NOT NULL,
  ADDR_TYPE_CD         VARCHAR2(5 BYTE)         NOT NULL,
  ADDR_TYPE_NM         VARCHAR2(30 BYTE)        NOT NULL,
  ADDR_TYPE_DESC_TX    VARCHAR2(100 BYTE)       NOT NULL,
  REC_MDFD_CNT         NUMBER(18)               NOT NULL,
  CIS_PROVENANCE_ID    NUMBER(20)               NOT NULL
)
TABLESPACE M_CIS_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN CIS.CIS_ADDRESS_TYPE.REC_MDFD_CNT IS 'Record modified count. Populated as "1" during insert and then increamented each time record is updated';


CREATE UNIQUE INDEX CIS.CIS_ADDRTYPE_CD_UK ON CIS.CIS_ADDRESS_TYPE
(ADDR_TYPE_CD)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX CIS.CIS_ADDRTYPE_PK ON CIS.CIS_ADDRESS_TYPE
(CIS_ADDRESS_TYPE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX CIS.CIS_PRVNC_ADDR_TYPE_FK_I ON CIS.CIS_ADDRESS_TYPE
(CIS_PROVENANCE_ID)
LOGGING
TABLESPACE M_CIS_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER CIS.CIS_ADDRESS_TYPE_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON CIS.CIS_ADDRESS_TYPE
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
mDML char(1) ;
V_SRC_APLCTN_PARTY_ID      NUMBER(22);

V_REC_CRTD_DT      DATE;

V_REC_CRTR_PARTY_ID      NUMBER(22);


begin
if  deleting then
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:old.CIS_PROVENANCE_ID;

INSERT INTO CIS_ADDRESS_TYPE_H( CIS_ADDRESS_TYPE_H_ID,

CIS_ADDRESS_TYPE_ID,

ADDR_TYPE_CD,

ADDR_TYPE_NM,

ADDR_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_ADDRESS_TYPE_H_S.nextval
,

:old.CIS_ADDRESS_TYPE_ID,

:old.ADDR_TYPE_CD,

:old.ADDR_TYPE_NM,

:old.ADDR_TYPE_DESC_TX,

:old.REC_MDFD_CNT,

:old.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, 'D');
else
if UPDATING then
mDML := 'U';
else
mDML := 'I' ;
end if;
select SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID INTO  V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID FROM
CIS_PROVENANCE WHERE CIS_PROVENANCE_ID=:new.CIS_PROVENANCE_ID;

INSERT INTO CIS_ADDRESS_TYPE_H( CIS_ADDRESS_TYPE_H_ID,

CIS_ADDRESS_TYPE_ID,

ADDR_TYPE_CD,

ADDR_TYPE_NM,

ADDR_TYPE_DESC_TX,


REC_MDFD_CNT,

CIS_PROVENANCE_ID,

SRC_APLCTN_PARTY_ID,REC_CRTD_DT,REC_CRTR_PARTY_ID , REC_MDFD_TYPE_CD)

VALUES


(CIS_ADDRESS_TYPE_H_S.nextval
,

:new.CIS_ADDRESS_TYPE_ID,

:new.ADDR_TYPE_CD,

:new.ADDR_TYPE_NM,

:new.ADDR_TYPE_DESC_TX,

:new.REC_MDFD_CNT,

:new.CIS_PROVENANCE_ID,

V_SRC_APLCTN_PARTY_ID,V_REC_CRTD_DT,V_REC_CRTR_PARTY_ID, mDML);
end if;
end CIS_ADDRESS_TYPE_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM CIS_ADDRESS_TYPE FOR CIS.CIS_ADDRESS_TYPE;


ALTER TABLE CIS.CIS_ADDRESS_TYPE ADD (
  CONSTRAINT CIS_ADDRTYPE_PK
  PRIMARY KEY
  (CIS_ADDRESS_TYPE_ID)
  USING INDEX CIS.CIS_ADDRTYPE_PK
  ENABLE VALIDATE,
  CONSTRAINT CIS_ADDRTYPE_CD_UK
  UNIQUE (ADDR_TYPE_CD)
  USING INDEX CIS.CIS_ADDRTYPE_CD_UK
  ENABLE VALIDATE);

ALTER TABLE CIS.CIS_ADDRESS_TYPE ADD (
  CONSTRAINT CIS_PRVNC_ADDR_TYPE_FK 
  FOREIGN KEY (CIS_PROVENANCE_ID) 
  REFERENCES CIS.CIS_PROVENANCE (CIS_PROVENANCE_ID)
  ENABLE VALIDATE);

GRANT SELECT ON CIS.CIS_ADDRESS_TYPE TO CIS_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON CIS.CIS_ADDRESS_TYPE TO CIS_RW;
